/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.util.concurrent.TimeUnit;

public final class TimeoutPolicyFactory
implements RequestPolicyFactory {
    private final long timeout;
    private final TimeUnit unit;

    public TimeoutPolicyFactory(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new TimeoutPolicy(next);
    }

    private final class TimeoutPolicy
    implements RequestPolicy {
        private final RequestPolicy next;

        TimeoutPolicy(RequestPolicy next) {
            this.next = next;
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            return this.next.sendAsync(request).timeout(TimeoutPolicyFactory.this.timeout, TimeoutPolicyFactory.this.unit);
        }
    }
}

