/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentMultiDequeMap<K, V> {
    private final Map<K, ConcurrentLinkedDeque<V>> data = Collections.synchronizedMap(new ConcurrentHashMap(16, 0.75f));
    private final AtomicInteger size = new AtomicInteger(0);
    private final LinkedList<K> lru = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        assert (key != null);
        AtomicInteger atomicInteger = this.size;
        synchronized (atomicInteger) {
            if (!this.data.containsKey(key)) {
                this.data.put(key, new ConcurrentLinkedDeque());
                this.lru.addLast(key);
            } else {
                this.lru.remove(key);
                this.lru.addLast(key);
            }
            this.data.get(key).add(value);
            this.size.incrementAndGet();
            return value;
        }
    }

    public ConcurrentLinkedDeque<V> get(K key) {
        return this.data.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V poll() {
        K key;
        AtomicInteger atomicInteger = this.size;
        synchronized (atomicInteger) {
            if (this.size.get() == 0) {
                return null;
            }
            key = this.lru.getFirst();
        }
        return this.poll(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V pop() {
        K key;
        AtomicInteger atomicInteger = this.size;
        synchronized (atomicInteger) {
            if (this.size.get() == 0) {
                return null;
            }
            key = this.lru.getLast();
        }
        return this.pop(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V poll(K key) {
        V ret;
        if (!this.data.containsKey(key)) {
            return null;
        }
        ConcurrentLinkedDeque<V> queue = this.data.get(key);
        AtomicInteger atomicInteger = this.size;
        synchronized (atomicInteger) {
            if (queue == null || queue.isEmpty()) {
                throw new NoSuchElementException("no items under key " + key);
            }
            this.size.decrementAndGet();
            ret = queue.poll();
            if (queue.isEmpty()) {
                this.data.remove(key);
                this.lru.remove(key);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V pop(K key) {
        V ret;
        if (!this.data.containsKey(key)) {
            return null;
        }
        ConcurrentLinkedDeque<V> queue = this.data.get(key);
        AtomicInteger atomicInteger = this.size;
        synchronized (atomicInteger) {
            if (queue == null || queue.isEmpty()) {
                throw new NoSuchElementException("no items under key " + key);
            }
            this.size.decrementAndGet();
            ret = queue.pop();
            if (queue.isEmpty()) {
                this.data.remove(key);
                this.lru.remove(key);
            }
        }
        return ret;
    }

    public int size() {
        return this.size.get();
    }

    public boolean containsKey(K key) {
        return this.data.containsKey(key) && this.data.get(key).size() > 0;
    }

    public Set<K> keys() {
        HashSet<K> keys = new HashSet<K>();
        for (K key : this.data.keySet()) {
            if (this.data.get(key).size() <= 0) continue;
            keys.add(key);
        }
        return keys;
    }

    public Set<V> values() {
        HashSet values = new HashSet();
        for (K k : this.keys()) {
            values.addAll(this.data.get(k));
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V value) {
        boolean removed;
        if (!this.data.containsKey(key)) {
            return false;
        }
        ConcurrentLinkedDeque<V> queue = this.data.get(key);
        AtomicInteger atomicInteger = this.size;
        synchronized (atomicInteger) {
            removed = queue.remove(value);
            if (removed) {
                this.size.decrementAndGet();
            }
            if (queue.isEmpty()) {
                this.data.remove(key);
                this.lru.remove(key);
            }
        }
        return removed;
    }
}

