/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.implementation.ODataEntity;
import com.microsoft.windowsazure.services.media.implementation.atom.EntryType;
import com.microsoft.windowsazure.services.media.implementation.content.AssetType;
import com.microsoft.windowsazure.services.media.models.AssetDeliveryPolicyInfo;
import com.microsoft.windowsazure.services.media.models.AssetFileInfo;
import com.microsoft.windowsazure.services.media.models.AssetOption;
import com.microsoft.windowsazure.services.media.models.AssetState;
import com.microsoft.windowsazure.services.media.models.ContentKeyInfo;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.LocatorInfo;
import java.util.Date;

public class AssetInfo
extends ODataEntity<AssetType> {
    public AssetInfo(EntryType entry, AssetType content) {
        super(entry, content);
    }

    public String getId() {
        return ((AssetType)this.getContent()).getId();
    }

    public String getName() {
        return ((AssetType)this.getContent()).getName();
    }

    public AssetState getState() {
        return AssetState.fromCode(((AssetType)this.getContent()).getState());
    }

    public Date getCreated() {
        return ((AssetType)this.getContent()).getCreated();
    }

    public Date getLastModified() {
        return ((AssetType)this.getContent()).getLastModified();
    }

    public String getAlternateId() {
        return ((AssetType)this.getContent()).getAlternateId();
    }

    public AssetOption getOptions() {
        return AssetOption.fromCode(((AssetType)this.getContent()).getOptions());
    }

    public String getUri() {
        return ((AssetType)this.getContent()).getUri();
    }

    public String getStorageAccountName() {
        return ((AssetType)this.getContent()).getStorageAccountName();
    }

    public LinkInfo<AssetFileInfo> getAssetFilesLink() {
        return this.getRelationLink("Files");
    }

    public LinkInfo<ContentKeyInfo> getContentKeysLink() {
        return this.getRelationLink("ContentKeys");
    }

    public LinkInfo<LocatorInfo> getLocatorsLink() {
        return this.getRelationLink("Locators");
    }

    public LinkInfo<AssetInfo> getParentAssetsLink() {
        return this.getRelationLink("ParentAssets");
    }

    public LinkInfo<AssetDeliveryPolicyInfo> getDeliveryPoliciesLink() {
        return this.getRelationLink("DeliveryPolicies");
    }
}

