/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction;

import com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction.OpenIdConnectDiscoveryDocument;
import com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction.TokenClaim;
import com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction.TokenType;
import com.microsoft.windowsazure.services.media.implementation.templates.tokenrestriction.TokenVerificationKey;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="TokenRestrictionTemplate")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TokenRestrictionTemplate {
    @XmlElementWrapper(name="AlternateVerificationKeys")
    @XmlElement(name="TokenVerificationKey")
    private List<TokenVerificationKey> alternateVerificationKeys;
    @XmlElement(name="Audience", required=true)
    private URI audience;
    @XmlElement(name="Issuer", required=true)
    private URI issuer;
    @XmlElement(name="PrimaryVerificationKey", nillable=true)
    private TokenVerificationKey primaryVerificationKey;
    @XmlElementWrapper(name="RequiredClaims")
    @XmlElement(name="TokenClaim")
    private List<TokenClaim> requiredClaims;
    @XmlElement(name="TokenType")
    private TokenType tokenType;
    @XmlElement(name="OpenIdConnectDiscoveryDocument")
    private OpenIdConnectDiscoveryDocument openIdConnectDiscoveryDocument;

    private TokenRestrictionTemplate() {
        this.setTokenType(TokenType.SWT);
        this.initCollections();
    }

    public TokenRestrictionTemplate(TokenType tokenType) {
        this.setTokenType(tokenType);
        this.initCollections();
    }

    private void initCollections() {
        this.setRequiredClaims(new ArrayList<TokenClaim>());
        this.setAlternateVerificationKeys(new ArrayList<TokenVerificationKey>());
    }

    public URI getAudience() {
        return this.audience;
    }

    public TokenRestrictionTemplate setAudience(URI audience) {
        this.audience = audience;
        return this;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public TokenRestrictionTemplate setIssuer(URI issuer) {
        this.issuer = issuer;
        return this;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public TokenRestrictionTemplate setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public TokenVerificationKey getPrimaryVerificationKey() {
        return this.primaryVerificationKey;
    }

    public TokenRestrictionTemplate setPrimaryVerificationKey(TokenVerificationKey primaryVerificationKey) {
        this.primaryVerificationKey = primaryVerificationKey;
        return this;
    }

    public List<TokenClaim> getRequiredClaims() {
        return this.requiredClaims;
    }

    public TokenRestrictionTemplate setRequiredClaims(List<TokenClaim> requiredClaims) {
        this.requiredClaims = requiredClaims;
        return this;
    }

    public List<TokenVerificationKey> getAlternateVerificationKeys() {
        return this.alternateVerificationKeys;
    }

    public TokenRestrictionTemplate setAlternateVerificationKeys(List<TokenVerificationKey> alternateVerificationKeys) {
        this.alternateVerificationKeys = alternateVerificationKeys;
        return this;
    }

    public OpenIdConnectDiscoveryDocument getOpenIdConnectDiscoveryDocument() {
        return this.openIdConnectDiscoveryDocument;
    }

    public TokenRestrictionTemplate setOpenIdConnectDiscoveryDocument(OpenIdConnectDiscoveryDocument openIdConnectDiscoveryDocument) {
        this.openIdConnectDiscoveryDocument = openIdConnectDiscoveryDocument;
        return this;
    }
}

