/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.sun.mail.util.LineInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.activation.DataSource;

public class StatusLine {
    private static final int DELIMITER = -1;
    private int status;
    private String reason;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatusLine create(DataSource dataSource) {
        StatusLine statusLine;
        LineInputStream stream = new LineInputStream(dataSource.getInputStream());
        try {
            String line = stream.readLine();
            StringReader lineReader = new StringReader(line);
            StatusLine.expect(lineReader, "HTTP/1.1");
            StatusLine.expect(lineReader, " ");
            String statusString = StatusLine.extractInput(lineReader, 32);
            String reason = StatusLine.extractInput(lineReader, -1);
            statusLine = new StatusLine().setStatus(Integer.parseInt(statusString)).setReason(reason);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return statusLine;
    }

    private static void expect(Reader reader, String string) {
        try {
            byte[] byteArray = string.getBytes("UTF-8");
            for (int i = 0; i < string.length(); ++i) {
                int ch = reader.read();
                if (ch == byteArray[i]) continue;
                throw new RuntimeException(String.format("Expected '%s', found '%s' instead", string, string.substring(0, i) + (char)ch));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String extractInput(Reader reader, int delimiter) {
        try {
            int ch;
            StringBuilder sb = new StringBuilder();
            while ((ch = reader.read()) != -1 && ch != delimiter) {
                sb.append((char)ch);
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public StatusLine setStatus(int status) {
        this.status = status;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public StatusLine setReason(String reason) {
        this.reason = reason;
        return this;
    }
}

