/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.formatter;

import com.marvinformatics.formatter.CacheableFormatter;
import com.marvinformatics.formatter.ResultCollector;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.RecursiveAction;
import java.util.stream.Stream;
import org.codehaus.plexus.util.MatchPatterns;

public class RecursiveWalk
extends RecursiveAction {
    private static final long serialVersionUID = 6913234076030245489L;
    private final Stream<Path> paths;
    private final ThreadLocal<CacheableFormatter> javaFormatter;
    private final ResultCollector resultCollector;
    private final ThreadLocal<CacheableFormatter> jsFormatter;
    private final MatchPatterns excludes;

    public RecursiveWalk(ThreadLocal<CacheableFormatter> javaFormatter, ThreadLocal<CacheableFormatter> jsFormatter, ResultCollector resultCollector, Stream<Path> stream, MatchPatterns excludes) {
        this.paths = stream;
        this.javaFormatter = javaFormatter;
        this.jsFormatter = jsFormatter;
        this.resultCollector = resultCollector;
        this.excludes = excludes;
    }

    public RecursiveWalk(ThreadLocal<CacheableFormatter> javaFormatter, ThreadLocal<CacheableFormatter> jsFormatter, ResultCollector resultCollector, Path path, MatchPatterns excludes) {
        this(javaFormatter, jsFormatter, resultCollector, Collections.singletonList(path).stream(), excludes);
    }

    @Override
    protected void compute() {
        final ArrayList walks = new ArrayList();
        ((Stream)this.paths.parallel()).forEach(path -> {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (RecursiveWalk.this.matchExclusions(dir)) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (!dir.equals(path)) {
                            RecursiveWalk w = new RecursiveWalk((ThreadLocal<CacheableFormatter>)RecursiveWalk.this.javaFormatter, (ThreadLocal<CacheableFormatter>)RecursiveWalk.this.jsFormatter, RecursiveWalk.this.resultCollector, dir, RecursiveWalk.this.excludes);
                            w.fork();
                            walks.add(w);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String name = file.getName(file.getNameCount() - 1).toString();
                        if (RecursiveWalk.this.matchExclusions(file)) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (name.endsWith(".java")) {
                            RecursiveWalk.this.resultCollector.collect(((CacheableFormatter)RecursiveWalk.this.javaFormatter.get()).formatFile(file));
                        }
                        if (name.endsWith(".js")) {
                            RecursiveWalk.this.resultCollector.collect(((CacheableFormatter)RecursiveWalk.this.jsFormatter.get()).formatFile(file));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                this.completeExceptionally(e);
            }
        });
        for (RecursiveWalk w : walks) {
            w.join();
        }
    }

    private boolean matchExclusions(Path path) {
        return this.excludes.matches(path.toAbsolutePath().toString(), true);
    }
}

