/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.formatter;

import com.google.common.collect.Lists;
import com.marvinformatics.formatter.ConfigurationSource;
import com.marvinformatics.formatter.FormatterExecuter;
import com.marvinformatics.formatter.LineEnding;
import com.marvinformatics.formatter.M2eConfigurer;
import com.marvinformatics.formatter.ResultCollector;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="format", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=false, threadSafe=true)
public class FormatterMojo
extends AbstractMojo
implements ConfigurationSource {
    @Parameter(defaultValue="${project.build.sourceDirectory}", property="sourceDirectory", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", readonly=true, required=true)
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File targetDirectory;
    @Parameter(defaultValue=".", property="project.basedir", readonly=true, required=true)
    File basedir;
    @Parameter
    private File[] directories;
    @Parameter(property="formatter.includes")
    private String[] includes;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="1.5", property="maven.compiler.source", required=true)
    private String compilerSource;
    @Parameter(defaultValue="1.5", property="maven.compiler.source", required=true)
    private String compilerCompliance;
    @Parameter(defaultValue="1.5", property="maven.compiler.target", required=true)
    private String compilerTargetPlatform;
    @Parameter(property="project.build.sourceEncoding", required=true)
    private String encoding;
    @Parameter(defaultValue="AUTO", property="lineending", required=true)
    private LineEnding lineEnding;
    @Parameter(defaultValue="src/config/eclipse/formatter/java.xml", property="configfile", required=true)
    private String configFile;
    @Parameter(defaultValue="src/config/eclipse/formatter/javascript.xml", property="configjsfile", required=true)
    private String configJsFile;
    @Parameter(defaultValue="false", alias="skip", property="formatter.skip")
    private Boolean skipFormatting;
    @Parameter(defaultValue="false", property="aggregator", required=true)
    protected boolean aggregator;
    @Parameter(defaultValue="${project.executionRoot}", required=true)
    protected boolean executionRoot;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.aggregator && !this.executionRoot) {
            return;
        }
        if (this.skip()) {
            this.getLog().info((CharSequence)"Formatting is skipped");
            return;
        }
        if (this.buildContext.getClass().getName().contains("m2e")) {
            new M2eConfigurer(this, this.buildContext).configure();
        } else {
            this.getLog().info((CharSequence)"Preparing to format files");
            try {
                ResultCollector rc = new FormatterExecuter(this).execute();
                this.getLog().info((CharSequence)("Successfully formatted: " + rc.successCount() + " file(s)"));
                this.getLog().info((CharSequence)("Fail to format        : " + rc.failCount() + " file(s)"));
                this.getLog().info((CharSequence)("Skipped               : " + rc.skippedCount() + " file(s)"));
                this.getLog().info((CharSequence)("Approximate time taken: " + rc.getWatch().elapsed(TimeUnit.SECONDS) + "s"));
            }
            catch (Throwable e) {
                this.getLog().error((CharSequence)"Error running formatter", e);
            }
        }
    }

    public String getCompilerSources() {
        return this.compilerSource;
    }

    public String getCompilerCompliance() {
        return this.compilerCompliance;
    }

    public String getCompilerCodegenTargetPlatform() {
        return this.compilerTargetPlatform;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public Charset getEncoding() {
        return Charset.forName(this.encoding);
    }

    public LineEnding lineEnding() {
        return this.lineEnding;
    }

    public boolean isDryRun() {
        return false;
    }

    public boolean skip() {
        return this.skipFormatting;
    }

    public String encoding() {
        return this.encoding;
    }

    public String javaConfig() {
        return this.configFile;
    }

    public String jsConfig() {
        return this.configJsFile;
    }

    public String[] excludes() {
        return this.excludes;
    }

    public List<File> directories() {
        if (this.directories == null) {
            return Lists.newArrayList((Object[])new File[]{this.sourceDirectory, this.testSourceDirectory});
        }
        return Lists.newArrayList((Object[])this.directories);
    }

    public void info(String message) {
        this.getLog().info((CharSequence)message);
    }

    public void error(String message) {
        this.getLog().error((CharSequence)message);
    }

    public void debug(String message) {
        this.getLog().debug((CharSequence)message);
    }

    public void warn(String message, File sourceFile, Exception e) {
        this.getLog().warn((CharSequence)message);
        this.buildContext.addMessage(sourceFile, 0, 0, message, 1, (Throwable)e);
    }
}

