/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.formatter;

import com.marvinformatics.formatter.ConfigurationSource;
import com.marvinformatics.formatter.Formatter;
import com.marvinformatics.formatter.Result;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class CacheableFormatter {
    private final Formatter formatter;
    private final ConfigurationSource context;

    public CacheableFormatter(ConfigurationSource cfg, Formatter formatter) {
        this.context = cfg;
        this.formatter = formatter;
    }

    public Result formatFile(Path file) {
        try {
            this.context.debug("Processing file: " + file);
            String code = new String(Files.readAllBytes(file), this.context.getEncoding());
            String formattedCode = this.fixLineEnding(this.formatter.format(code));
            if (code.equals(formattedCode)) {
                this.context.debug("Equal code. Not writing result to file.");
                return Result.SKIPPED;
            }
            if (!this.context.isDryRun()) {
                Files.write(file, formattedCode.getBytes(this.context.getEncoding()), new OpenOption[0]);
            }
            return Result.SUCCESS;
        }
        catch (Exception e) {
            this.context.warn("Error formating: ", file.toFile().getAbsoluteFile(), e);
            return Result.FAIL;
        }
    }

    private String fixLineEnding(String code) {
        return this.context.lineEnding().fix(code);
    }
}

