/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.api;

import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import com.jfinal.weixin.sdk.kit.ParaMap;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.RetryUtils;
import com.jfinal.wxaapp.WxaConfig;
import com.jfinal.wxaapp.WxaConfigKit;
import com.jfinal.wxaapp.api.WxaAccessToken;
import java.util.Map;
import java.util.concurrent.Callable;

public class WxaAccessTokenApi {
    private static String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential";
    private static final String cachePrefix = "wxa:";

    public static WxaAccessToken getAccessToken() {
        WxaConfig wc = WxaConfigKit.getWxaConfig();
        WxaAccessToken result = WxaAccessTokenApi.getAvailableAccessToken(wc);
        if (result != null) {
            return result;
        }
        return WxaAccessTokenApi.refreshAccessTokenIfNecessary(wc);
    }

    private static WxaAccessToken getAvailableAccessToken(WxaConfig wc) {
        WxaAccessToken result;
        IAccessTokenCache accessTokenCache = ApiConfigKit.getAccessTokenCache();
        String accessTokenJson = accessTokenCache.get(cachePrefix + wc.getAppId());
        if (StrKit.notBlank((String)accessTokenJson) && (result = new WxaAccessToken(accessTokenJson)) != null && result.isAvailable()) {
            return result;
        }
        return null;
    }

    public static String getAccessTokenStr() {
        return WxaAccessTokenApi.getAccessToken().getAccessToken();
    }

    private static synchronized WxaAccessToken refreshAccessTokenIfNecessary(WxaConfig wc) {
        WxaAccessToken result = WxaAccessTokenApi.getAvailableAccessToken(wc);
        if (result != null) {
            return result;
        }
        return WxaAccessTokenApi.refreshAccessToken(wc);
    }

    public static WxaAccessToken refreshAccessToken() {
        return WxaAccessTokenApi.refreshAccessToken(WxaConfigKit.getWxaConfig());
    }

    public static WxaAccessToken refreshAccessToken(WxaConfig wc) {
        String appId = wc.getAppId();
        String appSecret = wc.getAppSecret();
        final Map<String, String> queryParas = ParaMap.create("appid", appId).put("secret", appSecret).getData();
        WxaAccessToken result = RetryUtils.retryOnException(3, new Callable<WxaAccessToken>(){

            @Override
            public WxaAccessToken call() throws Exception {
                String json = HttpUtils.get(url, queryParas);
                return new WxaAccessToken(json);
            }
        });
        if (null != result) {
            IAccessTokenCache accessTokenCache = ApiConfigKit.getAccessTokenCache();
            accessTokenCache.set(cachePrefix + wc.getAppId(), result.getCacheJson());
        }
        return result;
    }
}

