/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.jfinal;

import com.jfinal.aop.Before;
import com.jfinal.core.Controller;
import com.jfinal.ext.interceptor.NotAction;
import com.jfinal.kit.HttpKit;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import com.jfinal.weixin.iot.msg.InEquDataMsg;
import com.jfinal.weixin.iot.msg.InEqubindEvent;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.jfinal.MsgInterceptor;
import com.jfinal.weixin.sdk.kit.MsgEncryptKit;
import com.jfinal.weixin.sdk.msg.InMsgParser;
import com.jfinal.weixin.sdk.msg.in.InImageMsg;
import com.jfinal.weixin.sdk.msg.in.InLinkMsg;
import com.jfinal.weixin.sdk.msg.in.InLocationMsg;
import com.jfinal.weixin.sdk.msg.in.InMsg;
import com.jfinal.weixin.sdk.msg.in.InNotDefinedMsg;
import com.jfinal.weixin.sdk.msg.in.InShortVideoMsg;
import com.jfinal.weixin.sdk.msg.in.InTextMsg;
import com.jfinal.weixin.sdk.msg.in.InVideoMsg;
import com.jfinal.weixin.sdk.msg.in.InVoiceMsg;
import com.jfinal.weixin.sdk.msg.in.card.InCardPassCheckEvent;
import com.jfinal.weixin.sdk.msg.in.card.InCardPayOrderEvent;
import com.jfinal.weixin.sdk.msg.in.card.InCardSkuRemindEvent;
import com.jfinal.weixin.sdk.msg.in.card.InMerChantOrderEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUpdateMemberCardEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUserCardEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUserConsumeCardEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUserGetCardEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUserGiftingCardEvent;
import com.jfinal.weixin.sdk.msg.in.card.InUserPayFromCardEvent;
import com.jfinal.weixin.sdk.msg.in.event.InCustomEvent;
import com.jfinal.weixin.sdk.msg.in.event.InFollowEvent;
import com.jfinal.weixin.sdk.msg.in.event.InLocationEvent;
import com.jfinal.weixin.sdk.msg.in.event.InMassEvent;
import com.jfinal.weixin.sdk.msg.in.event.InMenuEvent;
import com.jfinal.weixin.sdk.msg.in.event.InNotDefinedEvent;
import com.jfinal.weixin.sdk.msg.in.event.InPoiCheckNotifyEvent;
import com.jfinal.weixin.sdk.msg.in.event.InQrCodeEvent;
import com.jfinal.weixin.sdk.msg.in.event.InShakearoundUserShakeEvent;
import com.jfinal.weixin.sdk.msg.in.event.InTemplateMsgEvent;
import com.jfinal.weixin.sdk.msg.in.event.InVerifyFailEvent;
import com.jfinal.weixin.sdk.msg.in.event.InVerifySuccessEvent;
import com.jfinal.weixin.sdk.msg.in.event.InWifiEvent;
import com.jfinal.weixin.sdk.msg.in.speech_recognition.InSpeechRecognitionResults;
import com.jfinal.weixin.sdk.msg.out.OutMsg;
import com.jfinal.weixin.sdk.msg.out.OutTextMsg;
import javax.servlet.http.HttpServletRequest;

public abstract class MsgController
extends Controller {
    private static final Log log = Log.getLog(MsgController.class);
    private String inMsgXml = null;
    private InMsg inMsg = null;

    @Before(value={MsgInterceptor.class})
    public void index() {
        InMsg msg;
        if (ApiConfigKit.isDevMode()) {
            System.out.println("\u63a5\u6536\u6d88\u606f:");
            System.out.println(this.getInMsgXml());
        }
        if ((msg = this.getInMsg()) instanceof InTextMsg) {
            this.processInTextMsg((InTextMsg)msg);
        } else if (msg instanceof InImageMsg) {
            this.processInImageMsg((InImageMsg)msg);
        } else if (msg instanceof InSpeechRecognitionResults) {
            this.processInSpeechRecognitionResults((InSpeechRecognitionResults)msg);
        } else if (msg instanceof InVoiceMsg) {
            this.processInVoiceMsg((InVoiceMsg)msg);
        } else if (msg instanceof InVideoMsg) {
            this.processInVideoMsg((InVideoMsg)msg);
        } else if (msg instanceof InShortVideoMsg) {
            this.processInShortVideoMsg((InShortVideoMsg)msg);
        } else if (msg instanceof InLocationMsg) {
            this.processInLocationMsg((InLocationMsg)msg);
        } else if (msg instanceof InLinkMsg) {
            this.processInLinkMsg((InLinkMsg)msg);
        } else if (msg instanceof InCustomEvent) {
            this.processInCustomEvent((InCustomEvent)msg);
        } else if (msg instanceof InFollowEvent) {
            this.processInFollowEvent((InFollowEvent)msg);
        } else if (msg instanceof InQrCodeEvent) {
            this.processInQrCodeEvent((InQrCodeEvent)msg);
        } else if (msg instanceof InLocationEvent) {
            this.processInLocationEvent((InLocationEvent)msg);
        } else if (msg instanceof InMassEvent) {
            this.processInMassEvent((InMassEvent)msg);
        } else if (msg instanceof InMenuEvent) {
            this.processInMenuEvent((InMenuEvent)msg);
        } else if (msg instanceof InTemplateMsgEvent) {
            this.processInTemplateMsgEvent((InTemplateMsgEvent)msg);
        } else if (msg instanceof InShakearoundUserShakeEvent) {
            this.processInShakearoundUserShakeEvent((InShakearoundUserShakeEvent)msg);
        } else if (msg instanceof InVerifySuccessEvent) {
            this.processInVerifySuccessEvent((InVerifySuccessEvent)msg);
        } else if (msg instanceof InVerifyFailEvent) {
            this.processInVerifyFailEvent((InVerifyFailEvent)msg);
        } else if (msg instanceof InPoiCheckNotifyEvent) {
            this.processInPoiCheckNotifyEvent((InPoiCheckNotifyEvent)msg);
        } else if (msg instanceof InWifiEvent) {
            this.processInWifiEvent((InWifiEvent)msg);
        } else if (msg instanceof InUserCardEvent) {
            this.processInUserCardEvent((InUserCardEvent)msg);
        } else if (msg instanceof InUpdateMemberCardEvent) {
            this.processInUpdateMemberCardEvent((InUpdateMemberCardEvent)msg);
        } else if (msg instanceof InUserPayFromCardEvent) {
            this.processInUserPayFromCardEvent((InUserPayFromCardEvent)msg);
        } else if (msg instanceof InMerChantOrderEvent) {
            this.processInMerChantOrderEvent((InMerChantOrderEvent)msg);
        } else if (msg instanceof InCardPassCheckEvent) {
            this.processInCardPassCheckEvent((InCardPassCheckEvent)msg);
        } else if (msg instanceof InCardPayOrderEvent) {
            this.processInCardPayOrderEvent((InCardPayOrderEvent)msg);
        } else if (msg instanceof InCardSkuRemindEvent) {
            this.processInCardSkuRemindEvent((InCardSkuRemindEvent)msg);
        } else if (msg instanceof InUserConsumeCardEvent) {
            this.processInUserConsumeCardEvent((InUserConsumeCardEvent)msg);
        } else if (msg instanceof InUserGetCardEvent) {
            this.processInUserGetCardEvent((InUserGetCardEvent)msg);
        } else if (msg instanceof InUserGiftingCardEvent) {
            this.processInUserGiftingCardEvent((InUserGiftingCardEvent)msg);
        } else if (msg instanceof InEqubindEvent) {
            this.processInEqubindEvent((InEqubindEvent)msg);
        } else if (msg instanceof InEquDataMsg) {
            this.processInEquDataMsg((InEquDataMsg)msg);
        } else if (msg instanceof InEqubindEvent) {
            this.processInEqubindEvent((InEqubindEvent)msg);
        } else if (msg instanceof InEquDataMsg) {
            this.processInEquDataMsg((InEquDataMsg)msg);
        } else if (msg instanceof InNotDefinedEvent) {
            log.error("\u672a\u80fd\u8bc6\u522b\u7684\u4e8b\u4ef6\u7c7b\u578b\u3002 \u6d88\u606f xml \u5185\u5bb9\u4e3a\uff1a\n" + this.getInMsgXml());
            this.processIsNotDefinedEvent((InNotDefinedEvent)msg);
        } else if (msg instanceof InNotDefinedMsg) {
            log.error("\u672a\u80fd\u8bc6\u522b\u7684\u6d88\u606f\u7c7b\u578b\u3002 \u6d88\u606f xml \u5185\u5bb9\u4e3a\uff1a\n" + this.getInMsgXml());
            this.processIsNotDefinedMsg((InNotDefinedMsg)msg);
        }
    }

    public void render(OutMsg outMsg) {
        String outMsgXml = outMsg.toXml();
        if (ApiConfigKit.isDevMode()) {
            System.out.println("\u53d1\u9001\u6d88\u606f:");
            System.out.println(outMsgXml);
            System.out.println("--------------------------------------------------------------------------------\n");
        }
        if (ApiConfigKit.getApiConfig().isEncryptMessage()) {
            outMsgXml = MsgEncryptKit.encrypt(outMsgXml, this.getPara("timestamp"), this.getPara("nonce"));
        }
        this.renderText(outMsgXml, "text/xml");
    }

    public void renderOutTextMsg(String content) {
        OutTextMsg outMsg = new OutTextMsg(this.getInMsg());
        outMsg.setContent(content);
        this.render(outMsg);
    }

    @Before(value={NotAction.class})
    public String getInMsgXml() {
        if (this.inMsgXml == null) {
            this.inMsgXml = HttpKit.readData((HttpServletRequest)this.getRequest());
            if (ApiConfigKit.getApiConfig().isEncryptMessage()) {
                this.inMsgXml = MsgEncryptKit.decrypt(this.inMsgXml, this.getPara("timestamp"), this.getPara("nonce"), this.getPara("msg_signature"));
            }
        }
        if (StrKit.isBlank((String)this.inMsgXml)) {
            throw new RuntimeException("\u8bf7\u4e0d\u8981\u5728\u6d4f\u89c8\u5668\u4e2d\u8bf7\u6c42\u8be5\u8fde\u63a5,\u8c03\u8bd5\u8bf7\u67e5\u770bWIKI:http://git.oschina.net/jfinal/jfinal-weixin/wikis/JFinal-weixin-demo%E5%92%8C%E8%B0%83%E8%AF%95");
        }
        return this.inMsgXml;
    }

    @Before(value={NotAction.class})
    public InMsg getInMsg() {
        if (this.inMsg == null) {
            this.inMsg = InMsgParser.parse(this.getInMsgXml());
        }
        return this.inMsg;
    }

    protected abstract void processInTextMsg(InTextMsg var1);

    protected abstract void processInImageMsg(InImageMsg var1);

    protected abstract void processInVoiceMsg(InVoiceMsg var1);

    protected abstract void processInVideoMsg(InVideoMsg var1);

    protected abstract void processInShortVideoMsg(InShortVideoMsg var1);

    protected abstract void processInLocationMsg(InLocationMsg var1);

    protected abstract void processInLinkMsg(InLinkMsg var1);

    protected abstract void processInCustomEvent(InCustomEvent var1);

    protected abstract void processInFollowEvent(InFollowEvent var1);

    protected abstract void processInQrCodeEvent(InQrCodeEvent var1);

    protected abstract void processInLocationEvent(InLocationEvent var1);

    protected abstract void processInMassEvent(InMassEvent var1);

    protected abstract void processInMenuEvent(InMenuEvent var1);

    protected abstract void processInSpeechRecognitionResults(InSpeechRecognitionResults var1);

    protected abstract void processInTemplateMsgEvent(InTemplateMsgEvent var1);

    protected abstract void processInShakearoundUserShakeEvent(InShakearoundUserShakeEvent var1);

    protected abstract void processInVerifySuccessEvent(InVerifySuccessEvent var1);

    protected abstract void processInVerifyFailEvent(InVerifyFailEvent var1);

    protected abstract void processInPoiCheckNotifyEvent(InPoiCheckNotifyEvent var1);

    protected abstract void processInWifiEvent(InWifiEvent var1);

    protected abstract void processInUserCardEvent(InUserCardEvent var1);

    protected abstract void processInUpdateMemberCardEvent(InUpdateMemberCardEvent var1);

    protected abstract void processInUserPayFromCardEvent(InUserPayFromCardEvent var1);

    protected abstract void processInMerChantOrderEvent(InMerChantOrderEvent var1);

    protected abstract void processIsNotDefinedEvent(InNotDefinedEvent var1);

    protected abstract void processIsNotDefinedMsg(InNotDefinedMsg var1);

    protected abstract void processInUserGiftingCardEvent(InUserGiftingCardEvent var1);

    protected abstract void processInUserGetCardEvent(InUserGetCardEvent var1);

    protected abstract void processInUserConsumeCardEvent(InUserConsumeCardEvent var1);

    protected abstract void processInCardSkuRemindEvent(InCardSkuRemindEvent var1);

    protected abstract void processInCardPayOrderEvent(InCardPayOrderEvent var1);

    protected abstract void processInCardPassCheckEvent(InCardPassCheckEvent var1);

    protected abstract void processInEqubindEvent(InEqubindEvent var1);

    protected abstract void processInEquDataMsg(InEquDataMsg var1);
}

