/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.cache;

import com.jfinal.core.JFinal;
import com.jfinal.kit.HttpKit;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalTestTokenCache
implements IAccessTokenCache {
    private Map<String, String> map = new ConcurrentHashMap<String, String>();
    private final String onLineTokenUrl;

    public LocalTestTokenCache(String onLineTokenUrl) {
        this.onLineTokenUrl = onLineTokenUrl;
    }

    @Override
    public String get(String key) {
        String url = this.onLineTokenUrl + "?key=" + LocalTestTokenCache.enCodeUrl(key);
        return HttpKit.get((String)url);
    }

    @Override
    public void set(String key, String jsonValue) {
        this.map.put(key, jsonValue);
    }

    @Override
    public void remove(String key) {
        this.map.remove(key);
    }

    private static String enCodeUrl(String key) {
        try {
            return URLEncoder.encode(key, JFinal.me().getConstants().getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return key;
        }
    }
}

