/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.AccessToken;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import com.jfinal.weixin.sdk.kit.ParaMap;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.RetryUtils;
import java.util.Map;
import java.util.concurrent.Callable;

public class AccessTokenApi {
    private static String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential";

    public static AccessToken getAccessToken() {
        ApiConfig ac = ApiConfigKit.getApiConfig();
        AccessToken result = AccessTokenApi.getAvailableAccessToken(ac);
        if (result != null) {
            return result;
        }
        return AccessTokenApi.refreshAccessTokenIfNecessary(ac);
    }

    private static AccessToken getAvailableAccessToken(ApiConfig ac) {
        AccessToken result;
        IAccessTokenCache accessTokenCache = ApiConfigKit.getAccessTokenCache();
        String accessTokenJson = accessTokenCache.get(ac.getAppId());
        if (StrKit.notBlank((String)accessTokenJson) && (result = new AccessToken(accessTokenJson)) != null && result.isAvailable()) {
            return result;
        }
        return null;
    }

    public static String getAccessTokenStr() {
        return AccessTokenApi.getAccessToken().getAccessToken();
    }

    private static synchronized AccessToken refreshAccessTokenIfNecessary(ApiConfig ac) {
        AccessToken result = AccessTokenApi.getAvailableAccessToken(ac);
        if (result != null) {
            return result;
        }
        return AccessTokenApi.refreshAccessToken(ac);
    }

    public static AccessToken refreshAccessToken() {
        return AccessTokenApi.refreshAccessToken(ApiConfigKit.getApiConfig());
    }

    public static AccessToken refreshAccessToken(ApiConfig ac) {
        String appId = ac.getAppId();
        String appSecret = ac.getAppSecret();
        final Map<String, String> queryParas = ParaMap.create("appid", appId).put("secret", appSecret).getData();
        AccessToken result = RetryUtils.retryOnException(3, new Callable<AccessToken>(){

            @Override
            public AccessToken call() throws Exception {
                String json = HttpUtils.get(url, queryParas);
                return new AccessToken(json);
            }
        });
        if (null != result) {
            IAccessTokenCache accessTokenCache = ApiConfigKit.getAccessTokenCache();
            accessTokenCache.set(ac.getAppId(), result.getCacheJson());
        }
        return result;
    }
}

