/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.stat.ast;

import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import com.jfinal.template.stat.ast.Stat;
import java.io.Writer;

public class Output
extends Stat {
    private ExprList exprList;

    public Output(ExprList exprList, Location location) {
        if (exprList.length() == 0) {
            throw new ParseException("The expression of output directive like #(expression) can not be blank", location);
        }
        this.exprList = exprList;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        try {
            Object value = this.exprList.eval(scope);
            if (value != null) {
                String str = value.toString();
                writer.write(str, 0, str.length());
            }
        }
        catch (TemplateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

