/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.stat.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ast.ArrayIterator;
import com.jfinal.template.stat.ast.MapIterator;
import com.jfinal.template.stat.ast.NullIterator;
import com.jfinal.template.stat.ast.SingleObjectIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public class ForIteratorStatus {
    private Object outer;
    private int index;
    private int size;
    private Iterator<?> iterator;
    private Location location;

    public ForIteratorStatus(Object outer, Object target, Location location) {
        this.outer = outer;
        this.index = 0;
        this.location = location;
        this.init(target);
    }

    private void init(Object target) {
        if (target == null) {
            this.size = 0;
            this.iterator = NullIterator.me;
            return;
        }
        if (target instanceof Collection) {
            this.size = ((Collection)target).size();
            this.iterator = ((Collection)target).iterator();
            return;
        }
        if (target instanceof Map) {
            this.size = ((Map)target).size();
            this.iterator = new MapIterator(((Map)target).entrySet().iterator());
            return;
        }
        if (target.getClass().isArray()) {
            this.size = Array.getLength(target);
            this.iterator = new ArrayIterator(target, this.size);
            return;
        }
        if (target instanceof Iterator) {
            this.size = -1;
            this.iterator = (Iterator)target;
            return;
        }
        if (target instanceof Iterable) {
            this.size = -1;
            this.iterator = ((Iterable)target).iterator();
            return;
        }
        if (target instanceof Enumeration) {
            ArrayList list = Collections.list((Enumeration)target);
            this.size = list.size();
            this.iterator = list.iterator();
            return;
        }
        this.size = 1;
        this.iterator = new SingleObjectIterator(target);
    }

    Iterator<?> getIterator() {
        return this.iterator;
    }

    void nextState() {
        ++this.index;
    }

    public Object getOuter() {
        return this.outer;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCount() {
        return this.index + 1;
    }

    public int getSize() {
        if (this.size >= 0) {
            return this.size;
        }
        throw new TemplateException("No such method getSize() of the iterator", this.location);
    }

    public boolean getFirst() {
        return this.index == 0;
    }

    public boolean getLast() {
        return !this.iterator.hasNext();
    }

    public boolean getOdd() {
        return this.index % 2 == 0;
    }

    public boolean getEven() {
        return this.index % 2 != 0;
    }
}

