/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.stat.ast;

import com.jfinal.template.Env;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ForCtrl;
import com.jfinal.template.expr.ast.Logic;
import com.jfinal.template.stat.Ctrl;
import com.jfinal.template.stat.Scope;
import com.jfinal.template.stat.ast.ForIteratorStatus;
import com.jfinal.template.stat.ast.ForLoopStatus;
import com.jfinal.template.stat.ast.Stat;
import com.jfinal.template.stat.ast.StatList;
import java.io.Writer;
import java.util.Iterator;

public class For
extends Stat {
    private ForCtrl forCtrl;
    private StatList statList;
    private Stat _else;

    public For(ForCtrl forCtrl, StatList statList, Stat _else) {
        this.forCtrl = forCtrl;
        this.statList = statList;
        this._else = _else;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        scope = new Scope(scope);
        if (this.forCtrl.isIterator()) {
            this.forIterator(env, scope, writer);
        } else {
            this.forLoop(env, scope, writer);
        }
    }

    private void forIterator(Env env, Scope scope, Writer writer) {
        Ctrl ctrl = scope.getCtrl();
        Object outer = scope.get("for");
        ctrl.setLocalAssignment();
        ForIteratorStatus forIteratorStatus = new ForIteratorStatus(outer, this.forCtrl.getExpr().eval(scope), this.location);
        ctrl.setWisdomAssignment();
        scope.setLocal("for", forIteratorStatus);
        Iterator<?> it = forIteratorStatus.getIterator();
        String itemName = this.forCtrl.getId();
        while (it.hasNext()) {
            scope.setLocal(itemName, it.next());
            this.statList.exec(env, scope, writer);
            forIteratorStatus.nextState();
            if (!ctrl.isJump()) continue;
            if (ctrl.isBreak()) {
                ctrl.setJumpNone();
                break;
            }
            if (ctrl.isContinue()) {
                ctrl.setJumpNone();
                continue;
            }
            return;
        }
        if (this._else != null && forIteratorStatus.getIndex() == 0) {
            this._else.exec(env, scope, writer);
        }
    }

    private void forLoop(Env env, Scope scope, Writer writer) {
        Ctrl ctrl = scope.getCtrl();
        Object outer = scope.get("for");
        ForLoopStatus forLoopStatus = new ForLoopStatus(outer);
        scope.setLocal("for", forLoopStatus);
        Expr init = this.forCtrl.getInit();
        Expr cond = this.forCtrl.getCond();
        Expr update = this.forCtrl.getUpdate();
        ctrl.setLocalAssignment();
        init.eval(scope);
        while (cond == null || Logic.isTrue(cond.eval(scope))) {
            ctrl.setWisdomAssignment();
            this.statList.exec(env, scope, writer);
            ctrl.setLocalAssignment();
            forLoopStatus.nextState();
            if (ctrl.isJump()) {
                if (ctrl.isBreak()) {
                    ctrl.setJumpNone();
                    break;
                }
                if (ctrl.isContinue()) {
                    ctrl.setJumpNone();
                } else {
                    ctrl.setWisdomAssignment();
                    return;
                }
            }
            update.eval(scope);
        }
        ctrl.setWisdomAssignment();
        if (this._else != null && forLoopStatus.getIndex() == 0) {
            this._else.exec(env, scope, writer);
        }
    }
}

