/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.stat;

import com.jfinal.template.stat.Ctrl;
import java.util.HashMap;
import java.util.Map;

public class Scope {
    private final Scope parent;
    private final Ctrl ctrl;
    private Map data;
    private Map<String, Object> sharedObjectMap;

    public Scope(Map data, Map<String, Object> sharedObjectMap) {
        this.parent = null;
        this.ctrl = new Ctrl();
        this.data = data;
        this.sharedObjectMap = sharedObjectMap;
    }

    public Scope(Scope parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent can not be null.");
        }
        this.parent = parent;
        this.ctrl = parent.ctrl;
        this.data = null;
        this.sharedObjectMap = parent.sharedObjectMap;
    }

    public Ctrl getCtrl() {
        return this.ctrl;
    }

    public void set(Object key, Object value) {
        Scope cur = this;
        while (true) {
            if (cur.data != null && cur.data.containsKey(key)) {
                cur.data.put(key, value);
                return;
            }
            if (cur.parent == null) {
                if (cur.data == null) {
                    cur.data = new HashMap();
                }
                cur.data.put(key, value);
                return;
            }
            cur = cur.parent;
        }
    }

    public Object get(Object key) {
        Scope cur = this;
        while (cur != null) {
            if (cur.data != null && cur.data.containsKey(key)) {
                return cur.data.get(key);
            }
            cur = cur.parent;
        }
        return this.sharedObjectMap != null ? this.sharedObjectMap.get(key) : null;
    }

    public void remove(Object key) {
        Scope cur = this;
        while (cur != null) {
            if (cur.data != null && cur.data.containsKey(key)) {
                cur.data.remove(key);
                return;
            }
            cur = cur.parent;
        }
    }

    public void setLocal(Object key, Object value) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, value);
    }

    public Object getLocal(Object key) {
        return this.data != null ? this.data.get(key) : null;
    }

    public void removeLocal(Object key) {
        if (this.data != null) {
            this.data.remove(key);
        }
    }

    public void setGlobal(Object key, Object value) {
        Scope cur = this;
        while (true) {
            if (cur.parent == null) {
                cur.data.put(key, value);
                return;
            }
            cur = cur.parent;
        }
    }

    public Object getGlobal(Object key) {
        Scope cur = this;
        while (cur.parent != null) {
            cur = cur.parent;
        }
        return cur.data.get(key);
    }

    public void removeGlobal(Object key) {
        Scope cur = this;
        while (true) {
            if (cur.parent == null) {
                cur.data.remove(key);
                return;
            }
            cur = cur.parent;
        }
    }

    public Map getMapOfValue(Object key) {
        Scope cur = this;
        while (cur != null) {
            if (cur.data != null && cur.data.containsKey(key)) {
                return cur.data;
            }
            cur = cur.parent;
        }
        return null;
    }

    public Map getData() {
        return this.data;
    }

    public void setData(Map data) {
        this.data = data;
    }

    public Map getRootData() {
        Scope cur = this;
        while (cur.parent != null) {
            cur = cur.parent;
        }
        return cur.data;
    }

    public void setRootData(Map data) {
        Scope cur = this;
        while (true) {
            if (cur.parent == null) {
                cur.data = data;
                return;
            }
            cur = cur.parent;
        }
    }
}

