/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.ext.spring;

import com.jfinal.kit.StrKit;
import com.jfinal.template.Directive;
import com.jfinal.template.Engine;
import com.jfinal.template.ext.spring.JFinalView;
import com.jfinal.template.source.ClassPathSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

public class JFinalViewResolver
extends AbstractTemplateViewResolver {
    public static final Engine engine = new Engine();
    static List<String> sharedFunctionFiles = new ArrayList<String>();
    static boolean sessionInView = false;
    static boolean createSession = true;

    public Engine getEngine() {
        return engine;
    }

    public void setDevMode(boolean devMode) {
        engine.setDevMode(devMode);
    }

    public void setSharedFunction(String sharedFunctionFiles) {
        String[] fileArray;
        if (StrKit.isBlank(sharedFunctionFiles)) {
            throw new IllegalArgumentException("sharedFunctionFiles can not be blank");
        }
        for (String fileName : fileArray = sharedFunctionFiles.split(",")) {
            JFinalViewResolver.sharedFunctionFiles.add(fileName);
        }
    }

    public void addSharedFunction(String fileName) {
        sharedFunctionFiles.add(fileName);
    }

    public void addDirective(String directiveName, Directive directive) {
        engine.addDirective(directiveName, directive);
    }

    public void addSharedObject(String name, Object object) {
        engine.addSharedObject(name, object);
    }

    public void addSharedMethod(Object sharedMethodFromObject) {
        engine.addSharedMethod(sharedMethodFromObject);
    }

    public void addSharedMethod(Class<?> sharedMethodFromClass) {
        engine.addSharedMethod(sharedMethodFromClass);
    }

    public static void addExtensionMethod(Class<?> targetClass, Object objectOfExtensionClass) {
        Engine.addExtensionMethod(targetClass, objectOfExtensionClass);
    }

    public static void addExtensionMethod(Class<?> targetClass, Class<?> extensionClass) {
        Engine.addExtensionMethod(targetClass, extensionClass);
    }

    public void setSourceFactory(ISourceFactory sourceFactory) {
        if (sourceFactory instanceof ClassPathSourceFactory) {
            engine.setBaseTemplatePath(null);
        }
        engine.setSourceFactory(sourceFactory);
    }

    public void setBaseTemplatePath(String baseTemplatePath) {
        engine.setBaseTemplatePath(baseTemplatePath);
    }

    public void setSessionInView(boolean sessionInView) {
        JFinalViewResolver.sessionInView = sessionInView;
    }

    public void setCreateSession(boolean createSession) {
        JFinalViewResolver.createSession = createSession;
    }

    public void setEncoding(String encoding) {
        engine.setEncoding(encoding);
    }

    public void setDatePattern(String datePattern) {
        engine.setDatePattern(datePattern);
    }

    public JFinalViewResolver() {
        this.setViewClass(this.requiredViewClass());
        this.setOrder(0);
        this.setContentType("text/html;charset=UTF-8");
    }

    protected Class<?> requiredViewClass() {
        return JFinalView.class;
    }

    protected void initServletContext(ServletContext servletContext) {
        super.initServletContext(servletContext);
        this.initBaseTemplatePath(servletContext);
        this.initSharedFunction();
    }

    private void initBaseTemplatePath(ServletContext servletContext) {
        if (!(engine.getSourceFactory() instanceof ClassPathSourceFactory) && StrKit.isBlank(engine.getBaseTemplatePath())) {
            String path = servletContext.getRealPath("/");
            engine.setBaseTemplatePath(path);
        }
    }

    private void initSharedFunction() {
        for (String file : sharedFunctionFiles) {
            engine.addSharedFunction(file.trim());
        }
    }
}

