/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.ext.directive;

import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.FastStringWriter;
import com.jfinal.template.expr.ast.Const;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.expr.ast.Id;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.io.Writer;

public class StringDirective
extends Directive {
    private String name;
    private boolean isLocalAssignment = false;

    @Override
    public void setExprList(ExprList exprList) {
        Expr[] exprArray = exprList.getExprArray();
        if (exprArray.length == 0) {
            throw new ParseException("#string directive parameter cant not be null", this.location);
        }
        if (exprArray.length > 2) {
            throw new ParseException("wrong number of #string directive parameter, two parameters allowed at most", this.location);
        }
        if (!(exprArray[0] instanceof Id)) {
            throw new ParseException("#string first parameter must be identifier", this.location);
        }
        this.name = ((Id)exprArray[0]).getId();
        if (exprArray.length == 2 && exprArray[1] instanceof Const) {
            if (((Const)exprArray[1]).isBoolean()) {
                this.isLocalAssignment = ((Const)exprArray[1]).getBoolean();
            } else {
                throw new ParseException("#string sencond parameter must be boolean", this.location);
            }
        }
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        FastStringWriter fsw = new FastStringWriter();
        this.stat.exec(env, scope, fsw);
        if (this.isLocalAssignment) {
            scope.setLocal(this.name, fsw.toString());
        } else {
            scope.set(this.name, fsw.toString());
        }
    }

    @Override
    public boolean hasEnd() {
        return true;
    }
}

