/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.kit.ReflectKit;
import com.jfinal.template.expr.ast.MethodInfo;
import com.jfinal.template.expr.ast.MethodKit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SharedMethodKit {
    private static final Set<String> excludedMethodKey;
    private final List<SharedMethodInfo> sharedMethodList = new ArrayList<SharedMethodInfo>();
    private final ConcurrentHashMap<String, SharedMethodInfo> methodCache = new ConcurrentHashMap();

    public SharedMethodInfo getSharedMethodInfo(String methodName, Object[] argValues) {
        Class<?>[] argTypes = MethodKit.getArgTypes(argValues);
        String key = SharedMethodKit.getSharedMethodKey(methodName, argTypes);
        SharedMethodInfo method = this.methodCache.get(key);
        if (method == null && (method = this.doGetSharedMethodInfo(methodName, argTypes)) != null) {
            this.methodCache.putIfAbsent(key, method);
        }
        return method;
    }

    private SharedMethodInfo doGetSharedMethodInfo(String methodName, Class<?>[] argTypes) {
        for (SharedMethodInfo smi : this.sharedMethodList) {
            if (!smi.getName().equals(methodName)) continue;
            Class<?>[] paraTypes = smi.getParameterTypes();
            if (MethodKit.matchFixedArgTypes(paraTypes, argTypes)) {
                return smi;
            }
            if (!smi.isVarArgs() || !MethodKit.matchVarArgTypes(paraTypes, argTypes)) continue;
            return smi;
        }
        return null;
    }

    public void addSharedMethod(Object sharedMethodFromObject) {
        this.addSharedMethod(sharedMethodFromObject.getClass(), sharedMethodFromObject);
    }

    public void addSharedMethod(Class<?> sharedMethodFromClass) {
        this.addSharedMethod(sharedMethodFromClass, ReflectKit.newInstance(sharedMethodFromClass));
    }

    public void addSharedStaticMethod(Class<?> sharedStaticMethodFromClass) {
        this.addSharedMethod(sharedStaticMethodFromClass, null);
    }

    public void removeSharedMethod(String methodName) {
        Iterator<SharedMethodInfo> it = this.sharedMethodList.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(methodName)) continue;
            it.remove();
        }
    }

    public void removeSharedMethod(Class<?> sharedClass) {
        Iterator<SharedMethodInfo> it = this.sharedMethodList.iterator();
        while (it.hasNext()) {
            if (it.next().getClazz() != sharedClass) continue;
            it.remove();
        }
    }

    public void removeSharedMethod(Method method) {
        Iterator<SharedMethodInfo> it = this.sharedMethodList.iterator();
        while (it.hasNext()) {
            SharedMethodInfo current = it.next();
            String methodName = method.getName();
            if (!current.getName().equals(methodName)) continue;
            String key = SharedMethodKit.getSharedMethodKey(methodName, method.getParameterTypes());
            if (!current.getKey().equals(key)) continue;
            it.remove();
        }
    }

    private synchronized void addSharedMethod(Class<?> sharedClass, Object target) {
        Method[] methods;
        if (MethodKit.isForbiddenClass(sharedClass)) {
            throw new IllegalArgumentException("Forbidden class: " + sharedClass.getName());
        }
        for (Method method : methods = sharedClass.getMethods()) {
            String key = SharedMethodKit.getSharedMethodKey(method.getName(), method.getParameterTypes());
            if (excludedMethodKey.contains(key)) continue;
            for (SharedMethodInfo smi : this.sharedMethodList) {
                if (!smi.getKey().equals(key)) continue;
                throw new RuntimeException("The shared method is already exists : " + smi.toString());
            }
            if (target != null) {
                this.sharedMethodList.add(new SharedMethodInfo(key, sharedClass, method, target));
                continue;
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            this.sharedMethodList.add(new SharedMethodInfo(key, sharedClass, method, null));
        }
    }

    private static String getSharedMethodKey(String methodName, Class<?>[] argTypes) {
        StringBuilder key = new StringBuilder(64);
        key.append(methodName);
        if (argTypes != null && argTypes.length > 0) {
            MethodKit.createArgTypesDigest(argTypes, key);
        }
        return key.toString();
    }

    static {
        Method[] methods;
        excludedMethodKey = new HashSet<String>();
        for (Method method : methods = Object.class.getMethods()) {
            String key = SharedMethodKit.getSharedMethodKey(method.getName(), method.getParameterTypes());
            excludedMethodKey.add(key);
        }
    }

    static class SharedMethodInfo
    extends MethodInfo {
        final Object target;

        private SharedMethodInfo(String key, Class<?> clazz, Method method, Object target) {
            super(key, clazz, method);
            this.target = target;
        }

        public Object invoke(Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return super.invoke(this.target, args);
        }

        Class<?> getClazz() {
            return this.clazz;
        }
    }
}

