/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.expr.ast.FieldKit;
import com.jfinal.template.expr.ast.Id;
import com.jfinal.template.expr.ast.MethodInfo;
import com.jfinal.template.expr.ast.MethodKit;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.lang.reflect.Array;
import java.util.Map;

public class Field
extends Expr {
    private Expr expr;
    private String fieldName;
    private String getterName;

    public Field(Expr expr, String fieldName, Location location) {
        if (expr == null) {
            throw new ParseException("The object for field access can not be null", location);
        }
        this.expr = expr;
        this.fieldName = fieldName;
        this.getterName = "get" + StrKit.firstCharToUpperCase(fieldName);
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        MethodInfo getter;
        Object target = this.expr.eval(scope);
        if (target == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            if (this.expr instanceof Id) {
                String id = ((Id)this.expr).getId();
                throw new TemplateException("\"" + id + "\" can not be null for accessed by \"" + id + "." + this.fieldName + "\"", this.location);
            }
            throw new TemplateException("Can not accessed by \"" + this.fieldName + "\" field from null target", this.location);
        }
        Class<?> targetClass = target.getClass();
        String key = FieldKit.getFieldKey(targetClass, this.getterName);
        try {
            getter = MethodKit.getGetterMethod(key, targetClass, this.getterName);
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
        try {
            if (getter != null) {
                return getter.invoke(target, ExprList.NULL_OBJECT_ARRAY);
            }
            if (target instanceof Model) {
                return ((Model)target).get(this.fieldName);
            }
            if (target instanceof Record) {
                return ((Record)target).get(this.fieldName);
            }
            if (target instanceof Map) {
                return ((Map)target).get(this.fieldName);
            }
            java.lang.reflect.Field field = FieldKit.getField(key, targetClass, this.fieldName);
            if (field != null) {
                return field.get(target);
            }
            if ("length".equals(this.fieldName) && target.getClass().isArray()) {
                return Array.getLength(target);
            }
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
        if (scope.getCtrl().isNullSafe()) {
            return null;
        }
        if (this.expr instanceof Id) {
            String id = ((Id)this.expr).getId();
            throw new TemplateException("Field not found: \"" + id + "." + this.fieldName + "\" and getter method not found: \"" + id + "." + this.getterName + "()\"", this.location);
        }
        throw new TemplateException("Field not found: \"" + this.fieldName + "\" and getter method not found: \"" + this.getterName + "()\"", this.location);
    }
}

