/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.stat.Scope;
import java.util.List;

public class ExprList
extends Expr {
    public static final Expr[] NULL_EXPR_ARRAY = new Expr[0];
    public static final Object[] NULL_OBJECT_ARRAY = new Object[0];
    public static final ExprList NULL_EXPR_LIST = new ExprList();
    private Expr[] exprArray;

    private ExprList() {
        this.exprArray = NULL_EXPR_ARRAY;
    }

    public ExprList(List<Expr> exprList) {
        this.exprArray = exprList != null && exprList.size() > 0 ? exprList.toArray(new Expr[exprList.size()]) : NULL_EXPR_ARRAY;
    }

    public Expr[] getExprArray() {
        return this.exprArray;
    }

    public Expr getExpr(int index) {
        if (index < 0 || index >= this.exprArray.length) {
            throw new TemplateException("Index out of bounds: index = " + index + ", length = " + this.exprArray.length, this.location);
        }
        return this.exprArray[index];
    }

    public int length() {
        return this.exprArray.length;
    }

    @Override
    public Object eval(Scope scope) {
        Object ret = null;
        for (Expr expr : this.exprArray) {
            ret = expr.eval(scope);
        }
        return ret;
    }

    public Object[] evalExprList(Scope scope) {
        if (this.exprArray.length == 0) {
            return NULL_OBJECT_ARRAY;
        }
        Object[] ret = new Object[this.exprArray.length];
        for (int i = 0; i < this.exprArray.length; ++i) {
            ret[i] = this.exprArray[i].eval(scope);
        }
        return ret;
    }
}

