/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr;

import com.jfinal.template.EngineConfig;
import com.jfinal.template.expr.ExprLexer;
import com.jfinal.template.expr.Sym;
import com.jfinal.template.expr.Tok;
import com.jfinal.template.expr.ast.Arith;
import com.jfinal.template.expr.ast.Array;
import com.jfinal.template.expr.ast.Assign;
import com.jfinal.template.expr.ast.Compare;
import com.jfinal.template.expr.ast.Const;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.expr.ast.Field;
import com.jfinal.template.expr.ast.ForCtrl;
import com.jfinal.template.expr.ast.Id;
import com.jfinal.template.expr.ast.IncDec;
import com.jfinal.template.expr.ast.Index;
import com.jfinal.template.expr.ast.Logic;
import com.jfinal.template.expr.ast.Map;
import com.jfinal.template.expr.ast.Method;
import com.jfinal.template.expr.ast.NullSafe;
import com.jfinal.template.expr.ast.RangeArray;
import com.jfinal.template.expr.ast.SharedMethod;
import com.jfinal.template.expr.ast.StaticField;
import com.jfinal.template.expr.ast.StaticMethod;
import com.jfinal.template.expr.ast.Ternary;
import com.jfinal.template.expr.ast.Unary;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParaToken;
import com.jfinal.template.stat.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class ExprParser {
    static final Tok EOF = new Tok(Sym.EOF, -1);
    Tok peek = null;
    int forward = 0;
    List<Tok> tokenList;
    Location location;
    ParaToken paraToken;
    EngineConfig engineConfig;

    public ExprParser(ParaToken paraToken, EngineConfig engineConfig, String fileName) {
        this.paraToken = paraToken;
        this.engineConfig = engineConfig;
        this.location = new Location(fileName, paraToken.getRow());
    }

    void initPeek() {
        this.peek = this.tokenList.get(this.forward);
    }

    Tok peek() {
        return this.peek;
    }

    Tok move() {
        this.peek = this.tokenList.get(++this.forward);
        return this.peek;
    }

    void resetForward(int position) {
        this.forward = position;
        this.peek = this.tokenList.get(this.forward);
    }

    Tok match(Sym sym) {
        Tok current = this.peek();
        if (current.sym == sym) {
            this.move();
            return current;
        }
        throw new ParseException("Expression error: can not match the symbol \"" + sym.value() + "\"", this.location);
    }

    public ExprList parseExprList() {
        return (ExprList)this.parse(true);
    }

    public ForCtrl parseForCtrl() {
        Expr forCtrl = this.parse(false);
        if (forCtrl instanceof ForCtrl) {
            return (ForCtrl)forCtrl;
        }
        throw new ParseException("The expression of #for directive is error", this.location);
    }

    Expr parse(boolean isExprList) {
        Expr expr;
        this.tokenList = new ExprLexer(this.paraToken, this.location).scan();
        if (this.tokenList.size() == 0) {
            return ExprList.NULL_EXPR_LIST;
        }
        this.tokenList.add(EOF);
        this.initPeek();
        Expr expr2 = expr = isExprList ? this.exprList() : this.forCtrl();
        if (this.peek() != EOF) {
            throw new ParseException("Expression error: can not match \"" + this.peek().value() + "\"", this.location);
        }
        return expr;
    }

    Expr exprList() {
        Expr stat;
        ArrayList<Expr> exprList = new ArrayList<Expr>();
        while ((stat = this.expr()) != null) {
            exprList.add(stat);
            if (this.peek().sym != Sym.COMMA) break;
            this.move();
            if (this.peek() != EOF) continue;
            throw new ParseException("Expression error: can not match the char of comma ','", this.location);
        }
        return new ExprList(exprList);
    }

    Expr expr() {
        return this.assign();
    }

    Expr assign() {
        Tok idTok = this.peek();
        if (idTok.sym != Sym.ID) {
            return this.ternary();
        }
        int begin = this.forward;
        if (this.move().sym == Sym.ASSIGN) {
            this.move();
            return new Assign(idTok.value(), this.expr(), this.location);
        }
        if (this.peek().sym == Sym.LBRACK) {
            this.move();
            Expr index = this.expr();
            this.match(Sym.RBRACK);
            if (this.peek().sym == Sym.ASSIGN) {
                this.move();
                return new Assign(idTok.value(), index, this.expr(), this.location);
            }
        }
        this.resetForward(begin);
        return this.ternary();
    }

    Expr ternary() {
        Expr cond = this.or();
        if (this.peek().sym == Sym.QUESTION) {
            this.move();
            Expr exprOne = this.expr();
            this.match(Sym.COLON);
            return new Ternary(cond, exprOne, this.expr(), this.location);
        }
        return cond;
    }

    Expr or() {
        Expr expr = this.and();
        Tok tok = this.peek();
        while (tok.sym == Sym.OR) {
            this.move();
            expr = new Logic(Sym.OR, expr, this.and(), this.location);
            tok = this.peek();
        }
        return expr;
    }

    Expr and() {
        Expr expr = this.equalNotEqual();
        Tok tok = this.peek();
        while (tok.sym == Sym.AND) {
            this.move();
            expr = new Logic(Sym.AND, expr, this.equalNotEqual(), this.location);
            tok = this.peek();
        }
        return expr;
    }

    Expr equalNotEqual() {
        Expr expr = this.greaterLess();
        Tok tok = this.peek();
        while (tok.sym == Sym.EQUAL || tok.sym == Sym.NOTEQUAL) {
            this.move();
            expr = new Compare(tok.sym, expr, this.greaterLess(), this.location);
            tok = this.peek();
        }
        return expr;
    }

    Expr greaterLess() {
        Expr expr = this.addSub();
        Tok tok = this.peek();
        if (tok.sym == Sym.LT || tok.sym == Sym.LE || tok.sym == Sym.GT || tok.sym == Sym.GE) {
            this.move();
            return new Compare(tok.sym, expr, this.addSub(), this.location);
        }
        return expr;
    }

    Expr addSub() {
        Expr expr = this.mulDivMod();
        Tok tok = this.peek();
        while (tok.sym == Sym.ADD || tok.sym == Sym.SUB) {
            this.move();
            expr = new Arith(tok.sym, expr, this.mulDivMod(), this.location);
            tok = this.peek();
        }
        return expr;
    }

    Expr mulDivMod() {
        Expr expr = this.nullSafe();
        Tok tok = this.peek();
        while (tok.sym == Sym.MUL || tok.sym == Sym.DIV || tok.sym == Sym.MOD) {
            this.move();
            expr = new Arith(tok.sym, expr, this.nullSafe(), this.location);
            tok = this.peek();
        }
        return expr;
    }

    Expr nullSafe() {
        Expr expr = this.unary();
        Tok tok = this.peek();
        while (tok.sym == Sym.NULL_SAFE) {
            this.move();
            expr = new NullSafe(expr, this.unary(), this.location);
            tok = this.peek();
        }
        return expr;
    }

    Expr unary() {
        Tok tok = this.peek();
        switch (tok.sym) {
            case NOT: {
                this.move();
                return new Logic(tok.sym, this.unary(), this.location);
            }
            case ADD: 
            case SUB: {
                this.move();
                return new Unary(tok.sym, this.unary(), this.location);
            }
            case INC: 
            case DEC: {
                this.move();
                return new IncDec(tok.sym, false, this.incDec(), this.location);
            }
        }
        return this.incDec();
    }

    Expr incDec() {
        Expr expr = this.staticMember();
        Tok tok = this.peek();
        if (tok.sym == Sym.INC || tok.sym == Sym.DEC) {
            this.move();
            return new IncDec(tok.sym, true, expr, this.location);
        }
        return expr;
    }

    Expr staticMember() {
        if (this.peek().sym != Sym.ID) {
            return this.sharedMethod();
        }
        int begin = this.forward;
        while (this.move().sym == Sym.DOT && this.move().sym == Sym.ID) {
        }
        if (this.peek().sym != Sym.STATIC || this.tokenList.get((int)(this.forward - 1)).sym != Sym.ID) {
            this.resetForward(begin);
            return this.sharedMethod();
        }
        String clazz = this.getClazz(begin);
        this.match(Sym.STATIC);
        String memberName = this.match(Sym.ID).value();
        if (this.peek().sym == Sym.LPAREN) {
            this.move();
            if (this.peek().sym == Sym.RPAREN) {
                this.move();
                return new StaticMethod(clazz, memberName, this.location);
            }
            ExprList exprList = (ExprList)this.exprList();
            this.match(Sym.RPAREN);
            return new StaticMethod(clazz, memberName, exprList, this.location);
        }
        return new StaticField(clazz, memberName, this.location);
    }

    String getClazz(int begin) {
        StringBuilder clazz = new StringBuilder();
        for (int i = begin; i < this.forward; ++i) {
            clazz.append(this.tokenList.get(i).value());
        }
        return clazz.toString();
    }

    Expr sharedMethod() {
        Tok tok = this.peek();
        if (tok.sym != Sym.ID) {
            return this.indexMethodField(null);
        }
        if (this.move().sym != Sym.LPAREN) {
            this.resetForward(this.forward - 1);
            return this.indexMethodField(null);
        }
        this.move();
        if (this.peek().sym == Sym.RPAREN) {
            SharedMethod sharedMethod = new SharedMethod(this.engineConfig.getSharedMethodKit(), tok.value(), ExprList.NULL_EXPR_LIST, this.location);
            this.move();
            return this.indexMethodField(sharedMethod);
        }
        ExprList exprList = (ExprList)this.exprList();
        SharedMethod sharedMethod = new SharedMethod(this.engineConfig.getSharedMethodKit(), tok.value(), exprList, this.location);
        this.match(Sym.RPAREN);
        return this.indexMethodField(sharedMethod);
    }

    Expr indexMethodField(Expr expr) {
        if (expr == null) {
            expr = this.map();
        }
        while (true) {
            Tok tok = this.peek();
            if (tok.sym == Sym.LBRACK) {
                this.move();
                Expr index = this.expr();
                this.match(Sym.RBRACK);
                expr = new Index(expr, index, this.location);
                continue;
            }
            if (tok.sym != Sym.DOT) {
                return expr;
            }
            tok = this.move();
            if (tok.sym != Sym.ID) {
                this.resetForward(this.forward - 1);
                return expr;
            }
            this.move();
            if (this.peek().sym != Sym.LPAREN) {
                expr = new Field(expr, tok.value(), this.location);
                continue;
            }
            this.move();
            if (this.peek().sym == Sym.RPAREN) {
                this.move();
                expr = new Method(expr, tok.value(), this.location);
                continue;
            }
            ExprList exprList = (ExprList)this.exprList();
            this.match(Sym.RPAREN);
            expr = new Method(expr, tok.value(), exprList, this.location);
        }
    }

    Expr map() {
        if (this.peek().sym != Sym.LBRACE) {
            return this.array();
        }
        LinkedHashMap<Object, Expr> mapEntry = new LinkedHashMap<Object, Expr>();
        Map map = new Map(mapEntry);
        this.move();
        if (this.peek().sym == Sym.RBRACE) {
            this.move();
            return map;
        }
        this.buildMapEntry(mapEntry);
        while (this.peek().sym == Sym.COMMA) {
            this.move();
            this.buildMapEntry(mapEntry);
        }
        this.match(Sym.RBRACE);
        return map;
    }

    void buildMapEntry(LinkedHashMap<Object, Expr> map) {
        Tok tok = this.peek();
        if (tok.sym == Sym.ID || tok.sym == Sym.STR) {
            this.move();
            this.match(Sym.COLON);
            Expr value = this.expr();
            if (value == null) {
                throw new ParseException("Expression error: the value on the right side of map entry can not be blank", this.location);
            }
            map.put(tok.value(), value);
            return;
        }
        throw new ParseException("Expression error: the value of map key must be identifier or String", this.location);
    }

    Expr array() {
        if (this.peek().sym != Sym.LBRACK) {
            return this.atom();
        }
        this.move();
        if (this.peek().sym == Sym.RBRACK) {
            this.move();
            return new Array(ExprList.NULL_EXPR_ARRAY, this.location);
        }
        ExprList exprList = (ExprList)this.exprList();
        if (exprList.length() == 1 && this.peek().sym == Sym.RANGE) {
            this.move();
            Expr end = this.expr();
            this.match(Sym.RBRACK);
            return new RangeArray(exprList.getExprArray()[0], end, this.location);
        }
        this.match(Sym.RBRACK);
        return new Array(exprList.getExprArray(), this.location);
    }

    Expr atom() {
        Tok tok = this.peek();
        switch (tok.sym) {
            case LPAREN: {
                this.move();
                Expr expr = this.expr();
                this.match(Sym.RPAREN);
                return expr;
            }
            case ID: {
                this.move();
                return new Id(tok.value());
            }
            case STR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                this.move();
                return new Const(tok.sym, tok.value());
            }
            case TRUE: {
                this.move();
                return Const.TRUE;
            }
            case FALSE: {
                this.move();
                return Const.FALSE;
            }
            case NULL: {
                this.move();
                return Const.NULL;
            }
            case COMMA: 
            case SEMICOLON: 
            case QUESTION: 
            case AND: 
            case OR: 
            case EQUAL: 
            case NOTEQUAL: 
            case RPAREN: 
            case RBRACK: 
            case RBRACE: 
            case RANGE: 
            case COLON: 
            case EOF: {
                return null;
            }
        }
        throw new ParseException("Expression error: can not match the symbol \"" + tok.value() + "\"", this.location);
    }

    Expr forCtrl() {
        Expr expr;
        ExprList exprList = (ExprList)this.exprList();
        if (this.peek().sym == Sym.SEMICOLON) {
            this.move();
            Expr cond = this.expr();
            this.match(Sym.SEMICOLON);
            Expr update = this.exprList();
            return new ForCtrl(exprList, cond, update, this.location);
        }
        if (exprList.length() == 1 && (expr = exprList.getExprArray()[0]) instanceof Id) {
            this.match(Sym.COLON);
            return new ForCtrl((Id)expr, this.expr(), this.location);
        }
        throw new ParseException("The expression of #for directive is error", this.location);
    }
}

