/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template;

import com.jfinal.template.Env;
import com.jfinal.template.FastStringWriter;
import com.jfinal.template.stat.Scope;
import com.jfinal.template.stat.ast.Stat;
import java.io.Writer;
import java.util.Map;

public class Template {
    private Env env;
    private Stat ast;

    public Template(Env env, Stat ast) {
        if (env == null || ast == null) {
            throw new IllegalArgumentException("env and ast can not be null");
        }
        this.env = env;
        this.ast = ast;
    }

    public void render(Map<?, ?> data, Writer writer) {
        this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), writer);
    }

    public void render(Writer writer) {
        this.ast.exec(this.env, new Scope(null, this.env.engineConfig.sharedObjectMap), writer);
    }

    public void render(Map<?, ?> data, FastStringWriter fastStringWriter) {
        this.ast.exec(this.env, new Scope(data, this.env.engineConfig.sharedObjectMap), fastStringWriter);
    }

    public StringBuilder renderToStringBuilder(Map<?, ?> data) {
        FastStringWriter fsw = new FastStringWriter();
        this.render(data, fsw);
        return fsw.getBuffer();
    }

    public String renderToString(Map<?, ?> data) {
        return this.renderToStringBuilder(data).toString();
    }

    public boolean isModified() {
        return this.env.isSourceListModified();
    }
}

