/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template;

import com.jfinal.template.EngineConfig;
import com.jfinal.template.source.ISource;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.ast.Define;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Env {
    protected EngineConfig engineConfig;
    protected Map<String, Define> functionMap = new HashMap<String, Define>();
    protected List<ISource> sourceList = null;

    public Env(EngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public void addFunction(Define function) {
        String fn = function.getFunctionName();
        if (this.functionMap.containsKey(fn)) {
            Define previous = this.functionMap.get(fn);
            throw new ParseException("Template function \"" + fn + "\" already defined in " + this.getAlreadyDefinedLocation(previous.getLocation()), function.getLocation());
        }
        this.functionMap.put(fn, function);
    }

    private String getAlreadyDefinedLocation(Location loc) {
        StringBuilder buf = new StringBuilder();
        if (loc.getTemplateFile() != null) {
            buf.append(loc.getTemplateFile()).append(", line ").append(loc.getRow());
        } else {
            buf.append("string template line ").append(loc.getRow());
        }
        return buf.toString();
    }

    public Define getFunction(String functionName) {
        Define func = this.functionMap.get(functionName);
        return func != null ? func : this.engineConfig.getSharedFunction(functionName);
    }

    Map<String, Define> getFunctionMap() {
        return this.functionMap;
    }

    public boolean isSourceListModified() {
        if (this.sourceList != null) {
            int size = this.sourceList.size();
            for (int i = 0; i < size; ++i) {
                if (!this.sourceList.get(i).isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public void addSource(ISource source) {
        if (this.sourceList == null) {
            this.sourceList = new ArrayList<ISource>();
        }
        this.sourceList.add(source);
    }
}

