/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.kit.JsonKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JsonRender
extends Render {
    private static final Set<String> excludedAttrs = new HashSet<String>(){
        private static final long serialVersionUID = 9186138395157680676L;
        {
            this.add("javax.servlet.request.ssl_session");
            this.add("javax.servlet.request.ssl_session_id");
            this.add("javax.servlet.request.ssl_session_mgr");
            this.add("javax.servlet.request.key_size");
            this.add("javax.servlet.request.cipher_suite");
        }
    };
    private static final String contentType = "application/json; charset=" + JsonRender.getEncoding();
    private static final String contentTypeForIE = "text/html; charset=" + JsonRender.getEncoding();
    private boolean forIE = false;
    private String jsonText;
    private String[] attrs;

    public static void addExcludedAttrs(String ... attrs) {
        if (attrs != null) {
            for (String attr : attrs) {
                excludedAttrs.add(attr);
            }
        }
    }

    public static void removeExcludedAttrs(String ... attrs) {
        if (attrs != null) {
            for (String attr : attrs) {
                excludedAttrs.remove(attr);
            }
        }
    }

    public static void clearExcludedAttrs() {
        excludedAttrs.clear();
    }

    public JsonRender forIE() {
        this.forIE = true;
        return this;
    }

    public JsonRender() {
    }

    public JsonRender(final String key, final Object value) {
        if (key == null) {
            throw new IllegalArgumentException("The parameter key can not be null.");
        }
        this.jsonText = JsonKit.toJson(new HashMap<String, Object>(){
            {
                this.put(key, value);
            }
        });
    }

    public JsonRender(String[] attrs) {
        if (attrs == null) {
            throw new IllegalArgumentException("The parameter attrs can not be null.");
        }
        this.attrs = attrs;
    }

    public JsonRender(String jsonText) {
        this.jsonText = jsonText == null ? "null" : jsonText;
    }

    public JsonRender(Object object) {
        this.jsonText = JsonKit.toJson(object);
    }

    @Override
    public void render() {
        if (this.jsonText == null) {
            this.buildJsonText();
        }
        PrintWriter writer = null;
        try {
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setDateHeader("Expires", 0L);
            this.response.setContentType(this.forIE ? contentTypeForIE : contentType);
            writer = this.response.getWriter();
            writer.write(this.jsonText);
            writer.flush();
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    private void buildJsonText() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.attrs != null) {
            for (String key : this.attrs) {
                map.put(key, this.request.getAttribute(key));
            }
        } else {
            Enumeration attrs = this.request.getAttributeNames();
            while (attrs.hasMoreElements()) {
                String key = (String)attrs.nextElement();
                if (excludedAttrs.contains(key)) continue;
                Object value = this.request.getAttribute(key);
                map.put(key, value);
            }
        }
        this.jsonText = JsonKit.toJson(map);
    }

    public String[] getAttrs() {
        return this.attrs;
    }

    public String getJsonText() {
        return this.jsonText;
    }

    public Boolean getForIE() {
        return this.forIE;
    }
}

