/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.sql;

import com.jfinal.plugin.activerecord.SqlPara;
import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Const;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.io.Writer;

public class ParaDirective
extends Directive {
    private int index = -1;

    @Override
    public void setExprList(ExprList exprList) {
        Expr expr;
        if (exprList.length() == 1 && (expr = exprList.getExpr(0)) instanceof Const && ((Const)expr).isInt()) {
            this.index = ((Const)expr).getInt();
            if (this.index < 0) {
                throw new ParseException("The index of para array must greater than -1", this.location);
            }
        }
        this.exprList = exprList;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        SqlPara sqlPara = (SqlPara)scope.get("_SQL_PARA_");
        if (sqlPara == null) {
            throw new TemplateException("#para or #p directive invoked by getSqlPara(...) method only", this.location);
        }
        this.write(writer, "?");
        if (this.index == -1) {
            sqlPara.addPara(this.exprList.eval(scope));
        } else {
            Object[] paras = (Object[])scope.get("_PARA_ARRAY_");
            if (paras == null) {
                throw new TemplateException("The #para(" + this.index + ") directive must invoked by getSqlPara(String, Object...) method", this.location);
            }
            if (this.index >= paras.length) {
                throw new TemplateException("The index of #para directive is out of bounds: " + this.index, this.location);
            }
            sqlPara.addPara(paras[this.index]);
        }
    }
}

