/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.generator;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class ModelGenerator {
    protected String packageTemplate = "package %s;%n%n";
    protected String importTemplate = "import %s.%s;%n%n";
    protected String classDefineTemplate = "/**%n * Generated by JFinal.%n */%n@SuppressWarnings(\"serial\")%npublic class %s extends %s<%s> {%n";
    protected String daoTemplate = "\tpublic static final %s dao = new %s().dao();%n";
    protected String modelPackageName;
    protected String baseModelPackageName;
    protected String modelOutputDir;
    protected boolean generateDaoInModel = false;

    public ModelGenerator(String modelPackageName, String baseModelPackageName, String modelOutputDir) {
        if (StrKit.isBlank(modelPackageName)) {
            throw new IllegalArgumentException("modelPackageName can not be blank.");
        }
        if (modelPackageName.contains("/") || modelPackageName.contains("\\")) {
            throw new IllegalArgumentException("modelPackageName error : " + modelPackageName);
        }
        if (StrKit.isBlank(baseModelPackageName)) {
            throw new IllegalArgumentException("baseModelPackageName can not be blank.");
        }
        if (baseModelPackageName.contains("/") || baseModelPackageName.contains("\\")) {
            throw new IllegalArgumentException("baseModelPackageName error : " + baseModelPackageName);
        }
        if (StrKit.isBlank(modelOutputDir)) {
            throw new IllegalArgumentException("modelOutputDir can not be blank.");
        }
        this.modelPackageName = modelPackageName;
        this.baseModelPackageName = baseModelPackageName;
        this.modelOutputDir = modelOutputDir;
    }

    public void setGenerateDaoInModel(boolean generateDaoInModel) {
        this.generateDaoInModel = generateDaoInModel;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate model ...");
        System.out.println("Model Output Dir: " + this.modelOutputDir);
        for (TableMeta tableMeta : tableMetas) {
            this.genModelContent(tableMeta);
        }
        this.writeToFile(tableMetas);
    }

    protected void genModelContent(TableMeta tableMeta) {
        StringBuilder ret = new StringBuilder();
        this.genPackage(ret);
        this.genImport(tableMeta, ret);
        this.genClassDefine(tableMeta, ret);
        this.genDao(tableMeta, ret);
        ret.append(String.format("}%n", new Object[0]));
        tableMeta.modelContent = ret.toString();
    }

    protected void genPackage(StringBuilder ret) {
        ret.append(String.format(this.packageTemplate, this.modelPackageName));
    }

    protected void genImport(TableMeta tableMeta, StringBuilder ret) {
        ret.append(String.format(this.importTemplate, this.baseModelPackageName, tableMeta.baseModelName));
    }

    protected void genClassDefine(TableMeta tableMeta, StringBuilder ret) {
        ret.append(String.format(this.classDefineTemplate, tableMeta.modelName, tableMeta.baseModelName, tableMeta.modelName));
    }

    protected void genDao(TableMeta tableMeta, StringBuilder ret) {
        if (this.generateDaoInModel) {
            ret.append(String.format(this.daoTemplate, tableMeta.modelName, tableMeta.modelName));
        } else {
            ret.append(String.format("\t%n", new Object[0]));
        }
    }

    protected void writeToFile(List<TableMeta> tableMetas) {
        try {
            for (TableMeta tableMeta : tableMetas) {
                this.writeToFile(tableMeta);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToFile(TableMeta tableMeta) throws IOException {
        String target;
        File file;
        File dir = new File(this.modelOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((file = new File(target = this.modelOutputDir + File.separator + tableMeta.modelName + ".java")).exists()) {
            return;
        }
        FileWriter fw = new FileWriter(file);
        try {
            fw.write(tableMeta.modelContent);
        }
        finally {
            fw.close();
        }
    }
}

