/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.json;

import com.jfinal.json.Json;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JFinalJson
extends Json {
    private static int defaultConvertDepth = 15;
    protected int convertDepth = defaultConvertDepth;
    protected String timestampPattern = "yyyy-MM-dd HH:mm:ss";
    protected String datePattern = "yyyy-MM-dd";

    public static void setDefaultConvertDepth(int defaultConvertDepth) {
        if (defaultConvertDepth < 2) {
            throw new IllegalArgumentException("defaultConvertDepth depth can not less than 2.");
        }
        JFinalJson.defaultConvertDepth = defaultConvertDepth;
    }

    public JFinalJson setConvertDepth(int convertDepth) {
        if (convertDepth < 2) {
            throw new IllegalArgumentException("convert depth can not less than 2.");
        }
        this.convertDepth = convertDepth;
        return this;
    }

    public JFinalJson setTimestampPattern(String timestampPattern) {
        if (StrKit.isBlank(timestampPattern)) {
            throw new IllegalArgumentException("timestampPattern can not be blank.");
        }
        this.timestampPattern = timestampPattern;
        return this;
    }

    @Override
    public Json setDatePattern(String datePattern) {
        if (StrKit.isBlank(datePattern)) {
            throw new IllegalArgumentException("datePattern can not be blank.");
        }
        this.datePattern = datePattern;
        return this;
    }

    public static JFinalJson getJson() {
        return new JFinalJson();
    }

    protected String mapToJson(Map map, int depth) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Iterator iter = map.entrySet().iterator();
        sb.append('{');
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Map.Entry entry = iter.next();
            this.toKeyValue(String.valueOf(entry.getKey()), entry.getValue(), sb, depth);
        }
        sb.append('}');
        return sb.toString();
    }

    protected void toKeyValue(String key, Object value, StringBuilder sb, int depth) {
        sb.append('\"');
        if (key == null) {
            sb.append("null");
        } else {
            this.escape(key, sb);
        }
        sb.append('\"').append(':');
        sb.append(this.toJson(value, depth));
    }

    protected String iteratorToJson(Iterator iter, int depth) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Object value = iter.next();
            if (value == null) {
                sb.append("null");
                continue;
            }
            sb.append(this.toJson(value, depth));
        }
        sb.append(']');
        return sb.toString();
    }

    protected String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        this.escape(s, sb);
        return sb.toString();
    }

    protected void escape(String s, StringBuilder sb) {
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String str = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - str.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(str.toUpperCase());
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
    }

    @Override
    public String toJson(Object object) {
        return this.toJson(object, this.convertDepth);
    }

    protected String toJson(Object value, int depth) {
        if (value == null || depth-- < 0) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + this.escape((String)value) + "\"";
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Date) {
            String dp;
            if (value instanceof Timestamp) {
                return "\"" + new SimpleDateFormat(this.timestampPattern).format(value) + "\"";
            }
            if (value instanceof Time) {
                return "\"" + value.toString() + "\"";
            }
            String string = dp = this.datePattern != null ? this.datePattern : this.getDefaultDatePattern();
            if (dp != null) {
                return "\"" + new SimpleDateFormat(dp).format(value) + "\"";
            }
            return "" + ((Date)value).getTime();
        }
        if (value instanceof Collection) {
            return this.iteratorToJson(((Collection)value).iterator(), depth);
        }
        if (value instanceof Map) {
            return this.mapToJson((Map)value, depth);
        }
        String result = this.otherToJson(value, depth);
        if (result != null) {
            return result;
        }
        return "\"" + this.escape(value.toString()) + "\"";
    }

    protected String otherToJson(Object value, int depth) {
        if (value instanceof Character) {
            return "\"" + this.escape(value.toString()) + "\"";
        }
        if (value instanceof Model) {
            Map<String, Object> map = CPI.getAttrs((Model)value);
            return this.mapToJson(map, depth);
        }
        if (value instanceof Record) {
            Map<String, Object> map = ((Record)value).getColumns();
            return this.mapToJson(map, depth);
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                list.add(Array.get(value, i));
            }
            return this.iteratorToJson(list.iterator(), depth);
        }
        if (value instanceof Iterator) {
            return this.iteratorToJson((Iterator)value, depth);
        }
        if (value instanceof Enumeration) {
            ArrayList list = Collections.list((Enumeration)value);
            return this.iteratorToJson(list.iterator(), depth);
        }
        if (value instanceof Enum) {
            return "\"" + ((Enum)value).toString() + "\"";
        }
        return this.beanToJson(value, depth);
    }

    protected String beanToJson(Object model, int depth) {
        Method[] methods;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Method m : methods = model.getClass().getMethods()) {
            String methodName = m.getName();
            int indexOfGet = methodName.indexOf("get");
            if (indexOfGet == 0 && methodName.length() > 3) {
                Class<?>[] types;
                String attrName = methodName.substring(3);
                if (attrName.equals("Class") || (types = m.getParameterTypes()).length != 0) continue;
                try {
                    Object value = m.invoke(model, new Object[0]);
                    map.put(StrKit.firstCharToLowerCase(attrName), value);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            int indexOfIs = methodName.indexOf("is");
            if (indexOfIs != 0 || methodName.length() <= 2) continue;
            String attrName = methodName.substring(2);
            Class<?>[] types = m.getParameterTypes();
            if (types.length != 0) continue;
            try {
                Object value = m.invoke(model, new Object[0]);
                map.put(StrKit.firstCharToLowerCase(attrName), value);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.mapToJson(map, depth);
    }

    @Override
    public <T> T parse(String jsonString, Class<T> type) {
        throw new RuntimeException("jfinal 3.2\u9ed8\u8ba4 json \u5b9e\u73b0\u6682\u4e0d\u652f\u6301 json \u5230 object \u7684\u8f6c\u6362,\u5efa\u8bae\u4f7f\u7528 active recrord \u7684 Generator \u751f\u6210 base model\uff0c\u518d\u901a\u8fc7 me.setJsonFactory(new MixedJsonFactory()) \u6765\u652f\u6301");
    }
}

