/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.aop;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorManager;
import com.jfinal.aop.Invocation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

class Callback
implements MethodInterceptor {
    private Object injectTarget = null;
    private final Interceptor[] injectInters;
    private static final Set<String> excludedMethodName = Callback.buildExcludedMethodName();
    private static final InterceptorManager interMan = InterceptorManager.me();

    public Callback() {
        this.injectInters = InterceptorManager.NULL_INTERS;
    }

    public Callback(Interceptor ... injectInters) {
        this.checkInjectInterceptors(injectInters);
        this.injectInters = injectInters;
    }

    public Callback(Object injectTarget, Interceptor ... injectInters) {
        if (injectTarget == null) {
            throw new IllegalArgumentException("injectTarget can not be null.");
        }
        this.checkInjectInterceptors(injectInters);
        this.injectTarget = injectTarget;
        this.injectInters = injectInters;
    }

    private void checkInjectInterceptors(Interceptor ... injectInters) {
        if (injectInters == null) {
            throw new IllegalArgumentException("injectInters can not be null.");
        }
        for (Interceptor inter : injectInters) {
            if (inter != null) continue;
            throw new IllegalArgumentException("interceptor in injectInters can not be null.");
        }
    }

    public Object intercept(Object target, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (excludedMethodName.contains(method.getName())) {
            if (this.injectTarget == null || method.getName().equals("finalize")) {
                return methodProxy.invokeSuper(target, args);
            }
            return methodProxy.invoke(this.injectTarget, args);
        }
        if (this.injectTarget != null) {
            target = this.injectTarget;
            Interceptor[] finalInters = interMan.buildServiceMethodInterceptor(this.injectInters, target.getClass(), method);
            Invocation invocation = new Invocation(target, method, args, methodProxy, finalInters);
            invocation.useInjectTarget = true;
            invocation.invoke();
            return invocation.getReturnValue();
        }
        Class<?> targetClass = target.getClass();
        if (targetClass.getName().indexOf("$$EnhancerByCGLIB") != -1) {
            targetClass = targetClass.getSuperclass();
        }
        Interceptor[] finalInters = interMan.buildServiceMethodInterceptor(this.injectInters, targetClass, method);
        Invocation invocation = new Invocation(target, method, args, methodProxy, finalInters);
        invocation.useInjectTarget = false;
        invocation.invoke();
        return invocation.getReturnValue();
    }

    private static final Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>();
        for (Method m : methods = Object.class.getDeclaredMethods()) {
            excludedMethodName.add(m.getName());
        }
        return excludedMethodName;
    }
}

