/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.sdk.deploy;

import com.heroku.sdk.deploy.Deployer;
import com.heroku.sdk.deploy.utils.RestClient;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class ConfigVars {
    private Deployer deployer;
    private String encodedApiKey;

    public ConfigVars(Deployer deployer, String encodedApiKey) {
        this.deployer = deployer;
        this.encodedApiKey = encodedApiKey;
    }

    public void merge(Map<String, String> configVars) throws Exception {
        Map<String, String> existingConfigVars = this.getConfigVars();
        this.deployer.logDebug("Heroku existing config variables: " + existingConfigVars.keySet());
        HashMap<String, String> newConfigVars = new HashMap<String, String>();
        for (String key : configVars.keySet()) {
            newConfigVars.putAll(this.addConfigVar(key, configVars.get(key), existingConfigVars));
        }
        this.setConfigVars(newConfigVars);
    }

    protected Map<String, String> getConfigVars() throws Exception {
        String urlStr = "https://api.heroku.com/apps/" + URLEncoder.encode(this.deployer.getName(), "UTF-8") + "/config-vars";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", this.encodedApiKey);
        headers.put("Accept", "application/vnd.heroku+json; version=3");
        Map m = RestClient.get(urlStr, headers);
        HashMap<String, String> configVars = new HashMap<String, String>();
        for (Object key : m.keySet()) {
            Object value = m.get(key);
            if (key instanceof String && value instanceof String) {
                configVars.put(key.toString(), value.toString());
                continue;
            }
            throw new Exception("Unexpected return type: " + m);
        }
        return configVars;
    }

    protected void setConfigVars(Map<String, String> configVars) throws IOException {
        if (!configVars.isEmpty()) {
            String urlStr = "https://api.heroku.com/apps/" + URLEncoder.encode(this.deployer.getName(), "UTF-8") + "/config-vars";
            String data = "{";
            boolean first = true;
            for (String key : configVars.keySet()) {
                String value = configVars.get(key);
                if (!first) {
                    data = data + ", ";
                }
                first = false;
                data = data + "\"" + key + "\"" + ":" + "\"" + StringEscapeUtils.escapeJson((String)value) + "\"";
            }
            data = data + "}";
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", this.encodedApiKey);
            headers.put("Accept", "application/vnd.heroku+json; version=3");
            RestClient.patch(urlStr, data, headers);
        }
    }

    private Map<String, String> addConfigVar(String key, String value, Map<String, String> existingConfigVars) {
        return this.addConfigVar(key, value, existingConfigVars, true);
    }

    private Map<String, String> addConfigVar(String key, String value, Map<String, String> existingConfigVars, Boolean force) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (!existingConfigVars.containsKey(key) || !value.equals(existingConfigVars.get(key)) && force.booleanValue()) {
            m.put(key, value);
        }
        return m;
    }
}

