/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.cache.impl.JCacheDetector;
import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.ClientConnectionStrategy;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.connection.nio.ClusterConnectorService;
import com.hazelcast.client.connection.nio.ClusterConnectorServiceImpl;
import com.hazelcast.client.connection.nio.DefaultClientConnectionStrategy;
import com.hazelcast.client.cp.internal.CPSubsystemImpl;
import com.hazelcast.client.cp.internal.session.ClientProxySessionManager;
import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.clientside.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.clientside.ClientDiscoveryService;
import com.hazelcast.client.impl.clientside.ClientDiscoveryServiceBuilder;
import com.hazelcast.client.impl.clientside.ClientDynamicClusterConfig;
import com.hazelcast.client.impl.clientside.ClientExceptionFactory;
import com.hazelcast.client.impl.clientside.ClientICacheManager;
import com.hazelcast.client.impl.clientside.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.clientside.ClientLoggingService;
import com.hazelcast.client.impl.clientside.DefaultClientExtension;
import com.hazelcast.client.impl.clientside.LifecycleServiceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetDistributedObjectsCodec;
import com.hazelcast.client.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.client.impl.statistics.Statistics;
import com.hazelcast.client.proxy.ClientClusterProxy;
import com.hazelcast.client.proxy.PartitionServiceProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientTransactionManagerService;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.client.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.spi.impl.ClientTransactionManagerServiceImpl;
import com.hazelcast.client.spi.impl.ClientUserCodeDeploymentService;
import com.hazelcast.client.spi.impl.NonSmartClientInvocationService;
import com.hazelcast.client.spi.impl.SmartClientInvocationService;
import com.hazelcast.client.spi.impl.listener.AbstractClientListenerService;
import com.hazelcast.client.spi.impl.listener.NonSmartClientListenerService;
import com.hazelcast.client.spi.impl.listener.SmartClientListenerService;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.diagnostics.BuildInfoPlugin;
import com.hazelcast.internal.diagnostics.ConfigPropertiesPlugin;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.internal.diagnostics.EventQueuePlugin;
import com.hazelcast.internal.diagnostics.MetricsPlugin;
import com.hazelcast.internal.diagnostics.NetworkingImbalancePlugin;
import com.hazelcast.internal.diagnostics.SystemLogPlugin;
import com.hazelcast.internal.diagnostics.SystemPropertiesPlugin;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.metricsets.ClassLoadingMetricSet;
import com.hazelcast.internal.metrics.metricsets.FileMetricSet;
import com.hazelcast.internal.metrics.metricsets.GarbageCollectionMetricSet;
import com.hazelcast.internal.metrics.metricsets.OperatingSystemMetricSet;
import com.hazelcast.internal.metrics.metricsets.RuntimeMetricSet;
import com.hazelcast.internal.metrics.metricsets.ThreadMetricSet;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.networking.Networking;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListenable;
import com.hazelcast.quorum.QuorumService;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ServiceLoader;
import com.hazelcast.util.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class HazelcastClientInstanceImpl
implements HazelcastInstance,
SerializationServiceSupport {
    private static final AtomicInteger CLIENT_ID = new AtomicInteger();
    private static final short PROTOCOL_VERSION = 1;
    private final HazelcastProperties properties;
    private final int id = CLIENT_ID.getAndIncrement();
    private final String instanceName;
    private final ClientFailoverConfig clientFailoverConfig;
    private final ClientConfig config;
    private final LifecycleServiceImpl lifecycleService;
    private final ClientConnectionManagerImpl connectionManager;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final AbstractClientInvocationService invocationService;
    private final ClientExecutionServiceImpl executionService;
    private final AbstractClientListenerService listenerService;
    private final ClientTransactionManagerServiceImpl transactionManager;
    private final NearCacheManager nearCacheManager;
    private final ProxyManager proxyManager;
    private final ConcurrentMap<String, Object> userContext;
    private final LoadBalancer loadBalancer;
    private final ClientExtension clientExtension;
    private final ClusterConnectorService clusterConnectorService;
    private final ClientConnectionStrategy clientConnectionStrategy;
    private final LoggingService loggingService;
    private final MetricsRegistryImpl metricsRegistry;
    private final Statistics statistics;
    private final Diagnostics diagnostics;
    private final InternalSerializationService serializationService;
    private final ClientICacheManager hazelcastCacheManager;
    private final ClientQueryCacheContext queryCacheContext;
    private final ClientLockReferenceIdGenerator lockReferenceIdGenerator;
    private final ClientExceptionFactory clientExceptionFactory;
    private final ClientUserCodeDeploymentService userCodeDeploymentService;
    private final ClientDiscoveryService clientDiscoveryService;
    private final ClientProxySessionManager proxySessionManager;
    private final CPSubsystemImpl cpSubsystem;

    public HazelcastClientInstanceImpl(ClientConfig clientConfig, ClientFailoverConfig clientFailoverConfig, ClientConnectionManagerFactory clientConnectionManagerFactory, AddressProvider externalAddressProvider) {
        assert (clientConfig != null || clientFailoverConfig != null) : "At most one type of config can be provided";
        assert (clientConfig == null || clientFailoverConfig == null) : "At least one config should be provided ";
        this.config = clientConfig != null ? clientConfig : clientFailoverConfig.getClientConfigs().get(0);
        this.clientFailoverConfig = clientFailoverConfig;
        this.instanceName = this.config.getInstanceName() != null ? this.config.getInstanceName() : "hz.client_" + this.id;
        GroupConfig groupConfig = this.config.getGroupConfig();
        String loggingType = this.config.getProperty(GroupProperty.LOGGING_TYPE.getName());
        this.loggingService = new ClientLoggingService(groupConfig.getName(), loggingType, BuildInfoProvider.getBuildInfo(), this.instanceName);
        this.logGroupPasswordInfo();
        ClassLoader classLoader = this.config.getClassLoader();
        this.clientExtension = this.createClientInitializer(classLoader);
        this.clientExtension.beforeStart(this);
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.properties = new HazelcastProperties(this.config.getProperties());
        this.metricsRegistry = this.initMetricsRegistry();
        this.serializationService = this.clientExtension.createSerializationService((byte)-1);
        this.proxyManager = new ProxyManager(this);
        this.executionService = this.initExecutionService();
        this.loadBalancer = this.initLoadBalancer(this.config);
        this.transactionManager = new ClientTransactionManagerServiceImpl(this, this.loadBalancer);
        this.partitionService = new ClientPartitionServiceImpl(this);
        this.clientDiscoveryService = this.initClientDiscoveryService(externalAddressProvider);
        this.clientConnectionStrategy = this.initializeStrategy();
        this.connectionManager = (ClientConnectionManagerImpl)clientConnectionManagerFactory.createConnectionManager(this);
        this.clusterConnectorService = this.initClusterConnectorService();
        this.clusterService = new ClientClusterServiceImpl(this);
        this.invocationService = this.initInvocationService();
        this.listenerService = this.initListenerService();
        this.userContext = new ConcurrentHashMap<String, Object>();
        this.userContext.putAll(this.config.getUserContext());
        this.diagnostics = this.initDiagnostics();
        this.hazelcastCacheManager = new ClientICacheManager(this);
        this.queryCacheContext = new ClientQueryCacheContext(this);
        this.lockReferenceIdGenerator = new ClientLockReferenceIdGenerator();
        this.nearCacheManager = this.clientExtension.createNearCacheManager();
        this.clientExceptionFactory = this.initClientExceptionFactory();
        this.statistics = new Statistics(this);
        this.userCodeDeploymentService = new ClientUserCodeDeploymentService(this.config.getUserCodeDeploymentConfig(), classLoader);
        this.proxySessionManager = new ClientProxySessionManager(this);
        this.cpSubsystem = new CPSubsystemImpl(this);
    }

    private ClusterConnectorService initClusterConnectorService() {
        ClusterConnectorServiceImpl service = new ClusterConnectorServiceImpl(this, this.connectionManager, this.clientConnectionStrategy, this.clientDiscoveryService);
        this.connectionManager.addConnectionListener(service);
        return service;
    }

    private ClientConnectionStrategy initializeStrategy() {
        String className = this.properties.get("hazelcast.client.connection.strategy.classname");
        if (className != null) {
            try {
                ClassLoader configClassLoader = this.config.getClassLoader();
                return (ClientConnectionStrategy)ClassLoaderUtil.newInstance((ClassLoader)configClassLoader, (String)className);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        DefaultClientConnectionStrategy strategy = new DefaultClientConnectionStrategy();
        return strategy;
    }

    private ClientDiscoveryService initClientDiscoveryService(AddressProvider externalAddressProvider) {
        List<ClientConfig> configs;
        int tryCount;
        if (this.clientFailoverConfig == null) {
            tryCount = 0;
            configs = Collections.singletonList(this.config);
        } else {
            tryCount = this.clientFailoverConfig.getTryCount();
            configs = this.clientFailoverConfig.getClientConfigs();
        }
        ClientDiscoveryServiceBuilder builder = new ClientDiscoveryServiceBuilder(tryCount, configs, this.loggingService, externalAddressProvider, this.properties, this.clientExtension);
        return builder.build();
    }

    private Diagnostics initDiagnostics() {
        String name = "diagnostics-client-" + this.id + "-" + System.currentTimeMillis();
        ILogger logger = this.loggingService.getLogger(Diagnostics.class);
        return new Diagnostics(name, logger, this.instanceName, this.properties);
    }

    private MetricsRegistryImpl initMetricsRegistry() {
        ProbeLevel probeLevel = (ProbeLevel)this.properties.getEnum(Diagnostics.METRICS_LEVEL, ProbeLevel.class);
        ILogger logger = this.loggingService.getLogger(MetricsRegistryImpl.class);
        MetricsRegistryImpl metricsRegistry = new MetricsRegistryImpl(this.getName(), logger, probeLevel);
        return metricsRegistry;
    }

    private void startMetrics() {
        RuntimeMetricSet.register((MetricsRegistry)this.metricsRegistry);
        GarbageCollectionMetricSet.register((MetricsRegistry)this.metricsRegistry);
        OperatingSystemMetricSet.register((MetricsRegistry)this.metricsRegistry);
        ThreadMetricSet.register((MetricsRegistry)this.metricsRegistry);
        ClassLoadingMetricSet.register((MetricsRegistry)this.metricsRegistry);
        FileMetricSet.register((MetricsRegistry)this.metricsRegistry);
        this.metricsRegistry.scanAndRegister((Object)this.clientExtension.getMemoryStats(), "memory");
        this.metricsRegistry.collectMetrics(new Object[]{this.clientExtension});
        this.metricsRegistry.collectMetrics(new Object[]{this.executionService});
    }

    private LoadBalancer initLoadBalancer(ClientConfig config) {
        LoadBalancer lb = config.getLoadBalancer();
        if (lb == null) {
            lb = new RoundRobinLB();
        }
        return lb;
    }

    private AbstractClientInvocationService initInvocationService() {
        ClientNetworkConfig networkConfig = this.config.getNetworkConfig();
        if (networkConfig.isSmartRouting()) {
            return new SmartClientInvocationService(this, this.loadBalancer);
        }
        return new NonSmartClientInvocationService(this);
    }

    public int getId() {
        return this.id;
    }

    private ClientExtension createClientInitializer(ClassLoader classLoader) {
        try {
            String factoryId = ClientExtension.class.getName();
            Iterator iter = ServiceLoader.iterator(ClientExtension.class, (String)factoryId, (ClassLoader)classLoader);
            while (iter.hasNext()) {
                ClientExtension initializer = (ClientExtension)iter.next();
                if (initializer.getClass().equals(DefaultClientExtension.class)) continue;
                return initializer;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new DefaultClientExtension();
    }

    private AbstractClientListenerService initListenerService() {
        return this.config.getNetworkConfig().isSmartRouting() ? new SmartClientListenerService(this) : new NonSmartClientListenerService(this);
    }

    private ClientExecutionServiceImpl initExecutionService() {
        return new ClientExecutionServiceImpl(this.instanceName, this.config.getClassLoader(), this.properties, this.config.getExecutorPoolSize(), this.loggingService);
    }

    private void logGroupPasswordInfo() {
        if (!StringUtil.isNullOrEmpty((String)this.config.getGroupConfig().getPassword())) {
            ILogger logger = this.loggingService.getLogger(HazelcastClient.class);
            logger.info("A non-empty group password is configured for the Hazelcast client. Starting with Hazelcast version 3.11, clients with the same group name, but with different group passwords (that do not use authentication) will be accepted to a cluster. The group password configuration will be removed completely in a future release.");
        }
    }

    public void start() {
        try {
            this.lifecycleService.start();
            this.startMetrics();
            this.invocationService.start();
            this.clusterService.start();
            ClientContext clientContext = new ClientContext(this);
            this.userCodeDeploymentService.start();
            this.connectionManager.start();
            this.clientConnectionStrategy.init(clientContext);
            this.clientConnectionStrategy.start();
            this.diagnostics.start();
            this.diagnostics.register((DiagnosticsPlugin)new BuildInfoPlugin(this.loggingService.getLogger(BuildInfoPlugin.class)));
            this.diagnostics.register((DiagnosticsPlugin)new ConfigPropertiesPlugin(this.loggingService.getLogger(ConfigPropertiesPlugin.class), this.properties));
            this.diagnostics.register((DiagnosticsPlugin)new SystemPropertiesPlugin(this.loggingService.getLogger(SystemPropertiesPlugin.class)));
            this.diagnostics.register((DiagnosticsPlugin)new MetricsPlugin(this.loggingService.getLogger(MetricsPlugin.class), (MetricsRegistry)this.metricsRegistry, this.properties));
            this.diagnostics.register((DiagnosticsPlugin)new SystemLogPlugin(this.properties, (ConnectionListenable)this.connectionManager, (HazelcastInstance)this, this.loggingService.getLogger(SystemLogPlugin.class)));
            this.diagnostics.register((DiagnosticsPlugin)new NetworkingImbalancePlugin(this.properties, (Networking)this.connectionManager.getNetworking(), this.loggingService.getLogger(NetworkingImbalancePlugin.class)));
            this.diagnostics.register((DiagnosticsPlugin)new EventQueuePlugin(this.loggingService.getLogger(EventQueuePlugin.class), this.listenerService.getEventExecutor(), this.properties));
            this.metricsRegistry.collectMetrics(new Object[]{this.listenerService});
            this.proxyManager.init(this.config, clientContext);
            this.listenerService.start();
            this.loadBalancer.init(this.getCluster(), this.config);
            this.partitionService.start();
            this.statistics.start();
            this.clientExtension.afterStart(this);
            this.cpSubsystem.init(clientContext);
        }
        catch (Throwable e) {
            try {
                this.lifecycleService.terminate();
            }
            catch (Throwable t) {
                EmptyStatement.ignore((Throwable)t);
            }
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public void onClusterConnect(Connection ownerConnection) throws Exception {
        this.partitionService.listenPartitionTable(ownerConnection);
        this.clusterService.listenMembershipEvents(ownerConnection);
        this.userCodeDeploymentService.deploy(this, ownerConnection);
        this.proxyManager.createDistributedObjectsOnCluster(ownerConnection);
    }

    public MetricsRegistryImpl getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public HazelcastXAResource getXAResource() {
        return (HazelcastXAResource)this.getDistributedObject("hz:impl:xaService", "hz:impl:xaService");
    }

    public Config getConfig() {
        return new ClientDynamicClusterConfig(this);
    }

    public HazelcastProperties getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.instanceName;
    }

    public <E> IQueue<E> getQueue(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a queue instance with a null name is not allowed!");
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    public <E> ITopic<E> getTopic(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a topic instance with a null name is not allowed!");
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    public <E> ISet<E> getSet(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a set instance with a null name is not allowed!");
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    public <E> IList<E> getList(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a list instance with a null name is not allowed!");
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    public <K, V> IMap<K, V> getMap(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a map instance with a null name is not allowed!");
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a multi-map instance with a null name is not allowed!");
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a replicated map instance with a null name is not allowed!");
        return (ReplicatedMap)this.getDistributedObject("hz:impl:replicatedMapService", name);
    }

    public JobTracker getJobTracker(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a job tracker instance with a null name is not allowed!");
        return (JobTracker)this.getDistributedObject("hz:impl:mapReduceService", name);
    }

    public ILock getLock(String key) {
        Preconditions.checkNotNull((Object)key, (String)"Retrieving a lock instance with a null key is not allowed!");
        return (ILock)this.getDistributedObject("hz:impl:lockService", key);
    }

    public <E> ITopic<E> getReliableTopic(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a topic instance with a null name is not allowed!");
        return (ITopic)this.getDistributedObject("hz:impl:reliableTopicService", name);
    }

    public <E> Ringbuffer<E> getRingbuffer(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a ringbuffer instance with a null name is not allowed!");
        return (Ringbuffer)this.getDistributedObject("hz:impl:ringbufferService", name);
    }

    public ClientICacheManager getCacheManager() {
        return this.hazelcastCacheManager;
    }

    public Cluster getCluster() {
        return new ClientClusterProxy(this.clusterService);
    }

    public Client getLocalEndpoint() {
        return this.clusterService.getLocalClient();
    }

    public IExecutorService getExecutorService(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving an executor instance with a null name is not allowed!");
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    public DurableExecutorService getDurableExecutorService(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a durable executor instance with a null name is not allowed!");
        return (DurableExecutorService)this.getDistributedObject("hz:impl:durableExecutorService", name);
    }

    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(task);
    }

    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(options, task);
    }

    public TransactionContext newTransactionContext() {
        return this.transactionManager.newTransactionContext();
    }

    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.transactionManager.newTransactionContext(options);
    }

    public ClientTransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    public IdGenerator getIdGenerator(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving an ID-generator instance with a null name is not allowed!");
        return (IdGenerator)this.getDistributedObject("hz:impl:idGeneratorService", name);
    }

    public FlakeIdGenerator getFlakeIdGenerator(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a Flake ID-generator instance with a null name is not allowed!");
        return (FlakeIdGenerator)this.getDistributedObject("hz:impl:flakeIdGeneratorService", name);
    }

    public IAtomicLong getAtomicLong(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving an atomic-long instance with a null name is not allowed!");
        return (IAtomicLong)this.getDistributedObject("hz:impl:atomicLongService", name);
    }

    public CardinalityEstimator getCardinalityEstimator(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a cardinality estimator instance with a null name is not allowed!");
        return (CardinalityEstimator)this.getDistributedObject("hz:impl:cardinalityEstimatorService", name);
    }

    public PNCounter getPNCounter(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a PN counter instance with a null name is not allowed!");
        return (PNCounter)this.getDistributedObject("hz:impl:PNCounterService", name);
    }

    public <E> IAtomicReference<E> getAtomicReference(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving an atomic-reference instance with a null name is not allowed!");
        return (IAtomicReference)this.getDistributedObject("hz:impl:atomicReferenceService", name);
    }

    public ICountDownLatch getCountDownLatch(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a countdown-latch instance with a null name is not allowed!");
        return (ICountDownLatch)this.getDistributedObject("hz:impl:countDownLatchService", name);
    }

    public ISemaphore getSemaphore(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a semaphore instance with a null name is not allowed!");
        return (ISemaphore)this.getDistributedObject("hz:impl:semaphoreService", name);
    }

    public IScheduledExecutorService getScheduledExecutorService(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Retrieving a scheduled executor instance with a null name is not allowed!");
        return (IScheduledExecutorService)this.getDistributedObject("hz:impl:scheduledExecutorService", name);
    }

    public Collection<DistributedObject> getDistributedObjects() {
        try {
            ClientMessage request = ClientGetDistributedObjectsCodec.encodeRequest();
            ClientInvocationFuture future = new ClientInvocation(this, request, this.getName()).invoke();
            ClientMessage response = (ClientMessage)future.get();
            ClientGetDistributedObjectsCodec.ResponseParameters resultParameters = ClientGetDistributedObjectsCodec.decodeResponse((ClientMessage)response);
            Collection<? extends DistributedObject> distributedObjects = this.proxyManager.getDistributedObjects();
            HashSet<DistributedObjectInfo> localDistributedObjects = new HashSet<DistributedObjectInfo>();
            for (DistributedObject distributedObject : distributedObjects) {
                localDistributedObjects.add(new DistributedObjectInfo(distributedObject.getServiceName(), distributedObject.getName()));
            }
            List newDistributedObjectInfo = resultParameters.response;
            for (DistributedObjectInfo distributedObjectInfo : newDistributedObjectInfo) {
                localDistributedObjects.remove(distributedObjectInfo);
                this.getDistributedObject(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName());
            }
            for (DistributedObjectInfo distributedObjectInfo : localDistributedObjects) {
                this.proxyManager.destroyProxyLocally(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName());
            }
            return this.proxyManager.getDistributedObjects();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.proxyManager.addDistributedObjectListener(distributedObjectListener);
    }

    public boolean removeDistributedObjectListener(String registrationId) {
        return this.proxyManager.removeDistributedObjectListener(registrationId);
    }

    public PartitionService getPartitionService() {
        return new PartitionServiceProxy(this.partitionService, this.listenerService);
    }

    public QuorumService getQuorumService() {
        throw new UnsupportedOperationException();
    }

    public ClientService getClientService() {
        throw new UnsupportedOperationException();
    }

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return (T)this.proxyManager.getOrCreateProxy(serviceName, name);
    }

    public CPSubsystem getCPSubsystem() {
        return this.cpSubsystem;
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }

    public InternalSerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientUserCodeDeploymentService getUserCodeDeploymentService() {
        return this.userCodeDeploymentService;
    }

    public ClientProxySessionManager getProxySessionManager() {
        return this.proxySessionManager;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientClusterService getClientClusterService() {
        return this.clusterService;
    }

    public ClientExecutionService getClientExecutionService() {
        return this.executionService;
    }

    public ClientPartitionService getClientPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public NearCacheManager getNearCacheManager() {
        return this.nearCacheManager;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientExtension getClientExtension() {
        return this.clientExtension;
    }

    public short getProtocolVersion() {
        return 1;
    }

    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    public void doShutdown(boolean isGraceful) {
        if (isGraceful) {
            this.proxySessionManager.shutdown();
        }
        this.proxyManager.destroy();
        this.connectionManager.shutdown();
        this.clientConnectionStrategy.shutdown();
        this.clusterConnectorService.shutdown();
        this.clientDiscoveryService.shutdown();
        this.clusterService.shutdown();
        this.partitionService.reset();
        this.transactionManager.shutdown();
        this.invocationService.shutdown();
        this.executionService.shutdown();
        this.listenerService.shutdown();
        this.nearCacheManager.destroyAllNearCaches();
        this.metricsRegistry.shutdown();
        this.diagnostics.shutdown();
        this.serializationService.dispose();
    }

    public ClientLockReferenceIdGenerator getLockReferenceIdGenerator() {
        return this.lockReferenceIdGenerator;
    }

    private ClientExceptionFactory initClientExceptionFactory() {
        boolean jCacheAvailable = JCacheDetector.isJCacheAvailable((ClassLoader)this.getClientConfig().getClassLoader());
        return new ClientExceptionFactory(jCacheAvailable);
    }

    public ClientExceptionFactory getClientExceptionFactory() {
        return this.clientExceptionFactory;
    }

    public ClusterConnectorService getClusterConnectorService() {
        return this.clusterConnectorService;
    }

    public ClientDiscoveryService getClientDiscoveryService() {
        return this.clientDiscoveryService;
    }

    public ClientConnectionStrategy getConnectionStrategy() {
        return this.clientConnectionStrategy;
    }

    public ClientFailoverConfig getFailoverConfig() {
        return this.clientFailoverConfig;
    }

    public ClientQueryCacheContext getQueryCacheContext() {
        return this.queryCacheContext;
    }
}

