/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.examples;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.IMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleMapTest {
    public static int THREAD_COUNT = 40;
    public static int ENTRY_COUNT = 10000;
    public static int VALUE_SIZE = 1000;
    public static final int STATS_SECONDS = 10;
    public static int GET_PERCENTAGE = 40;
    public static int PUT_PERCENTAGE = 40;
    static final Stats stats = new Stats();

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if ((arg = arg.trim()).startsWith("t")) {
                    THREAD_COUNT = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("c")) {
                    ENTRY_COUNT = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("v")) {
                    VALUE_SIZE = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("g")) {
                    GET_PERCENTAGE = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (!arg.startsWith("p")) continue;
                PUT_PERCENTAGE = Integer.parseInt(arg.substring(1));
            }
        } else {
            System.out.println("Help: sh test.sh t200 v130 p10 g85 ");
            System.out.println("    // means 200 threads, value-size 130 bytes, 10% put, 85% get");
            System.out.println("");
        }
        System.out.println("Starting Test with ");
        System.out.println("      Thread Count: " + THREAD_COUNT);
        System.out.println("       Entry Count: " + ENTRY_COUNT);
        System.out.println("        Value Size: " + VALUE_SIZE);
        System.out.println("    Get Percentage: " + GET_PERCENTAGE);
        System.out.println("    Put Percentage: " + PUT_PERCENTAGE);
        System.out.println(" Remove Percentage: " + (100 - (PUT_PERCENTAGE + GET_PERCENTAGE)));
        ExecutorService es = Executors.newFixedThreadPool(THREAD_COUNT);
        final HazelcastClient hazelcast = HazelcastClient.newHazelcastClient("dev", "dev-pass", "localhost:5701");
        for (int i = 0; i < THREAD_COUNT; ++i) {
            es.submit(new Runnable(){

                public void run() {
                    IMap map = hazelcast.getMap("default");
                    while (true) {
                        int key = (int)(Math.random() * (double)ENTRY_COUNT);
                        int operation = (int)(Math.random() * 100.0);
                        if (operation < GET_PERCENTAGE) {
                            map.get((Object)String.valueOf(key));
                            SimpleMapTest.stats.gets.incrementAndGet();
                            continue;
                        }
                        if (operation < GET_PERCENTAGE + PUT_PERCENTAGE) {
                            map.put((Object)String.valueOf(key), (Object)new byte[VALUE_SIZE]);
                            SimpleMapTest.stats.puts.incrementAndGet();
                            continue;
                        }
                        map.remove((Object)String.valueOf(key));
                        SimpleMapTest.stats.removes.incrementAndGet();
                    }
                }
            });
        }
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(10000L);
                        Stats statsNow = stats.getAndReset();
                        System.out.println(statsNow);
                        System.out.println("Operations per Second : " + statsNow.total() / 10L);
                    }
                }
                catch (InterruptedException ignored) {
                    return;
                }
            }
        });
    }

    public static class Stats {
        public AtomicLong gets = new AtomicLong();
        public AtomicLong puts = new AtomicLong();
        public AtomicLong removes = new AtomicLong();

        public Stats getAndReset() {
            long getsNow = this.gets.getAndSet(0L);
            long putsNow = this.puts.getAndSet(0L);
            long removesNow = this.removes.getAndSet(0L);
            Stats newOne = new Stats();
            newOne.gets.set(getsNow);
            newOne.puts.set(putsNow);
            newOne.removes.set(removesNow);
            return newOne;
        }

        public long total() {
            return this.gets.get() + this.puts.get() + this.removes.get();
        }

        public String toString() {
            return "total= " + this.total() + ", gets:" + this.gets.get() + ", puts:" + this.puts.get() + ", removes:" + this.removes.get();
        }
    }
}

