/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.query.PagingPredicate;
import com.hazelcast.util.IterationType;
import java.util.Comparator;
import java.util.Map;

public final class SortingUtil {
    private SortingUtil() {
    }

    public static int compare(Comparator<Map.Entry> comparator, IterationType iterationType, Map.Entry entry1, Map.Entry entry2) {
        Map.Entry comparable2;
        Map.Entry comparable1;
        if (comparator != null) {
            int result = comparator.compare(entry1, entry2);
            if (result != 0) {
                return result;
            }
            return entry1.getKey().hashCode() - entry2.getKey().hashCode();
        }
        switch (iterationType) {
            case KEY: {
                comparable1 = entry1.getKey();
                comparable2 = entry2.getKey();
                break;
            }
            case VALUE: {
                comparable1 = entry1.getValue();
                comparable2 = entry2.getValue();
                break;
            }
            default: {
                comparable1 = entry1;
                comparable2 = entry2;
            }
        }
        int result = comparable1 instanceof Comparable && comparable2 instanceof Comparable ? ((Comparable)((Object)comparable1)).compareTo(comparable2) : ((Object)comparable1).hashCode() - ((Object)comparable2).hashCode();
        if (result != 0) {
            return result;
        }
        return entry1.getKey().hashCode() - entry2.getKey().hashCode();
    }

    public static Comparator<Map.Entry> newComparator(final Comparator<Map.Entry> comparator, final IterationType iterationType) {
        return new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry entry1, Map.Entry entry2) {
                return SortingUtil.compare(comparator, iterationType, entry1, entry2);
            }
        };
    }

    public static Comparator<Map.Entry> newComparator(final PagingPredicate pagingPredicate) {
        return new Comparator<Map.Entry>(){

            @Override
            public int compare(Map.Entry entry1, Map.Entry entry2) {
                return SortingUtil.compare(pagingPredicate.getComparator(), pagingPredicate.getIterationType(), entry1, entry2);
            }
        };
    }
}

