/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.impl.NormalResponse;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ResponseHandlerFactory {
    private static final NoResponseHandler NO_RESPONSE_HANDLER = new NoResponseHandler();

    public static void setLocalResponseHandler(Operation op, Callback<Object> callback) {
        op.setResponseHandler(ResponseHandlerFactory.createLocalResponseHandler(op, callback));
    }

    public static ResponseHandler createLocalResponseHandler(Operation op, Callback<Object> callback) {
        return new LocalInvocationResponseHandler(callback, op.getCallId());
    }

    public static void setRemoteResponseHandler(NodeEngine nodeEngine, Operation op) {
        op.setResponseHandler(ResponseHandlerFactory.createRemoteResponseHandler(nodeEngine, op));
    }

    public static ResponseHandler createRemoteResponseHandler(NodeEngine nodeEngine, Operation op) {
        if (op.getCallId() == 0L) {
            if (op.returnsResponse()) {
                throw new HazelcastException("Op: " + op.getClass().getName() + " can not return response without call-id!");
            }
            return NO_RESPONSE_HANDLER;
        }
        return new RemoteInvocationResponseHandler(nodeEngine, op);
    }

    public static ResponseHandler createEmptyResponseHandler() {
        return NO_RESPONSE_HANDLER;
    }

    public static ResponseHandler createErrorLoggingResponseHandler(ILogger logger) {
        return new ErrorLoggingResponseHandler(logger);
    }

    private ResponseHandlerFactory() {
    }

    private static class LocalInvocationResponseHandler
    implements ResponseHandler {
        private final Callback<Object> callback;
        private final long callId;
        private final AtomicBoolean sent = new AtomicBoolean(false);

        private LocalInvocationResponseHandler(Callback<Object> callback, long callId) {
            this.callback = callback;
            this.callId = callId;
        }

        @Override
        public void sendResponse(Object obj) {
            if (!this.sent.compareAndSet(false, true)) {
                throw new ResponseAlreadySentException("NormalResponse already sent for callback: " + this.callback + ", current-response: : " + obj);
            }
            this.callback.notify(obj);
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }

    private static class RemoteInvocationResponseHandler
    implements ResponseHandler {
        private final NodeEngine nodeEngine;
        private final Operation op;
        private final AtomicBoolean sent = new AtomicBoolean(false);

        private RemoteInvocationResponseHandler(NodeEngine nodeEngine, Operation op) {
            this.nodeEngine = nodeEngine;
            this.op = op;
        }

        @Override
        public void sendResponse(Object obj) {
            long callId = this.op.getCallId();
            Connection conn = this.op.getConnection();
            if (!this.sent.compareAndSet(false, true)) {
                throw new ResponseAlreadySentException("NormalResponse already sent for call: " + callId + " to " + conn.getEndPoint() + ", current-response: " + obj);
            }
            NormalResponse response = !(obj instanceof NormalResponse) ? new NormalResponse(obj, this.op.getCallId(), 0, this.op.isUrgent()) : (NormalResponse)obj;
            this.nodeEngine.getOperationService().send(response, this.op.getCallerAddress());
        }

        @Override
        public boolean isLocal() {
            return false;
        }
    }

    private static class ErrorLoggingResponseHandler
    implements ResponseHandler {
        private final ILogger logger;

        private ErrorLoggingResponseHandler(ILogger logger) {
            this.logger = logger;
        }

        @Override
        public void sendResponse(Object obj) {
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                this.logger.severe(t);
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }

    private static class NoResponseHandler
    implements ResponseHandler {
        private NoResponseHandler() {
        }

        @Override
        public void sendResponse(Object obj) {
        }

        @Override
        public boolean isLocal() {
            return false;
        }
    }
}

