/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.InvocationClientRequest;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.QueryResult;
import com.hazelcast.map.operation.QueryOperation;
import com.hazelcast.map.operation.QueryPartitionOperation;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;

abstract class AbstractMapQueryRequest
extends InvocationClientRequest
implements Portable,
RetryableRequest,
SecureRequest {
    private String name;
    private IterationType iterationType;

    public AbstractMapQueryRequest() {
    }

    public AbstractMapQueryRequest(String name, IterationType iterationType) {
        this.name = name;
        this.iterationType = iterationType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void invoke() {
        Collection<MemberImpl> members = this.getClientEngine().getClusterService().getMemberList();
        int partitionCount = this.getClientEngine().getPartitionService().getPartitionCount();
        HashSet<Integer> plist = new HashSet<Integer>(partitionCount);
        ClientEndpoint endpoint = this.getEndpoint();
        QueryResultSet result = new QueryResultSet(null, this.iterationType, true);
        try {
            ArrayList<InternalCompletableFuture> flist = new ArrayList<InternalCompletableFuture>();
            Predicate predicate = this.getPredicate();
            for (MemberImpl memberImpl : members) {
                InternalCompletableFuture future = this.createInvocationBuilder("hz:impl:mapService", (Operation)new QueryOperation(this.name, predicate), memberImpl.getAddress()).invoke();
                flist.add(future);
            }
            for (Future future : flist) {
                List<Integer> list;
                QueryResult queryResult = (QueryResult)future.get();
                if (queryResult == null || (list = queryResult.getPartitionIds()) == null) continue;
                plist.addAll(list);
                result.addAll(queryResult.getResult());
            }
            if (plist.size() != partitionCount) {
                void var9_14;
                ArrayList<Integer> missingList = new ArrayList<Integer>();
                boolean bl = false;
                while (var9_14 < partitionCount) {
                    if (!plist.contains((int)var9_14)) {
                        missingList.add((int)var9_14);
                    }
                    ++var9_14;
                }
                ArrayList<InternalCompletableFuture> arrayList = new ArrayList<InternalCompletableFuture>(missingList.size());
                for (Integer n : missingList) {
                    QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.name, predicate);
                    queryPartitionOperation.setPartitionId(n);
                    try {
                        InternalCompletableFuture f = this.createInvocationBuilder("hz:impl:mapService", (Operation)queryPartitionOperation, n).invoke();
                        arrayList.add(f);
                    }
                    catch (Throwable t) {
                        throw ExceptionUtil.rethrow(t);
                    }
                }
                for (Future future : arrayList) {
                    QueryResult queryResult = (QueryResult)future.get();
                    result.addAll(queryResult.getResult());
                }
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        endpoint.sendResponse(result, this.getCallId());
    }

    protected abstract Predicate getPredicate();

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public final int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("t", this.iterationType.toString());
        this.writePortableInner(writer);
    }

    protected abstract void writePortableInner(PortableWriter var1) throws IOException;

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.iterationType = IterationType.valueOf(reader.readUTF("t"));
        this.readPortableInner(reader);
    }

    protected abstract void readPortableInner(PortableReader var1) throws IOException;

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "read");
    }
}

