/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.Member;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.EventObject;

@SuppressWarnings(value={"SE_BAD_FIELD"})
public class EntryEvent<K, V>
extends EventObject {
    private static final long serialVersionUID = -2296203982913729851L;
    protected final EntryEventType entryEventType;
    protected K key;
    protected V oldValue;
    protected V value;
    protected final Member member;
    protected final String name;

    public EntryEvent(Object source, Member member, int eventType, K key, V value) {
        this(source, member, eventType, key, null, value);
    }

    public EntryEvent(Object source, Member member, int eventType, K key, V oldValue, V value) {
        super(source);
        this.name = (String)source;
        this.member = member;
        this.key = key;
        this.oldValue = oldValue;
        this.value = value;
        this.entryEventType = EntryEventType.getByType(eventType);
    }

    @Override
    public Object getSource() {
        return this.name;
    }

    public K getKey() {
        return this.key;
    }

    public V getOldValue() {
        return this.oldValue;
    }

    public V getValue() {
        return this.value;
    }

    public Member getMember() {
        return this.member;
    }

    public EntryEventType getEventType() {
        return this.entryEventType;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "EntryEvent {" + this.getSource() + "} key=" + this.getKey() + ", oldValue=" + this.getOldValue() + ", value=" + this.getValue() + ", event=" + (Object)((Object)this.entryEventType) + ", by " + this.member;
    }
}

