/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MemberInfo
implements DataSerializable {
    Address address = null;
    String uuid;
    Map<String, Object> attributes = null;

    public MemberInfo() {
    }

    public MemberInfo(Address address) {
        this.address = address;
    }

    public MemberInfo(Address address, String uuid, Map<String, Object> attributes) {
        this.address = address;
        this.uuid = uuid;
        this.attributes = new HashMap<String, Object>(attributes);
    }

    public MemberInfo(MemberImpl member) {
        this(member.getAddress(), member.getUuid(), member.getAttributes());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size;
        this.address = new Address();
        this.address.readData(in);
        if (in.readBoolean()) {
            this.uuid = in.readUTF();
        }
        if ((size = in.readInt()) > 0) {
            this.attributes = new HashMap<String, Object>();
        }
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            Object value = in.readObject();
            this.attributes.put(key, value);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.address.writeData(out);
        boolean hasUuid = this.uuid != null;
        out.writeBoolean(hasUuid);
        if (hasUuid) {
            out.writeUTF(this.uuid);
        }
        out.writeInt(this.attributes == null ? 0 : this.attributes.size());
        if (this.attributes != null) {
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
    }

    public Address getAddress() {
        return this.address;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberInfo other = (MemberInfo)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    public String toString() {
        return "MemberInfo{address=" + this.address + '}';
    }
}

