/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.AuthenticationRequest;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.ClientResponse;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.Router;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientInSelectorImpl;
import com.hazelcast.client.connection.nio.ClientOutSelectorImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.ClientPacket;
import com.hazelcast.nio.DefaultSocketChannelWrapper;
import com.hazelcast.nio.IOSelector;
import com.hazelcast.nio.SocketChannelWrapper;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.nio.ssl.SSLSocketChannelWrapper;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnectionManagerImpl
implements ClientConnectionManager {
    private static final ILogger logger = Logger.getLogger(ClientConnectionManagerImpl.class);
    private int RETRY_COUNT = 20;
    private final ConcurrentMap<Address, Object> connectionLockMap = new ConcurrentHashMap<Address, Object>();
    static final int KILO_BYTE = 1024;
    public static final int BUFFER_SIZE = 16384;
    private final AtomicInteger connectionIdGen = new AtomicInteger();
    private final HazelcastClient client;
    private final Router router;
    private final SocketInterceptor socketInterceptor;
    private final SocketOptions socketOptions;
    private final IOSelector inSelector;
    private final IOSelector outSelector;
    private final boolean smartRouting;
    private volatile ClientConnection ownerConnection = null;
    private final Object ownerConnectionLock = new Object();
    private final Credentials credentials;
    private volatile ClientPrincipal principal;
    private final AtomicInteger callIdIncrementer = new AtomicInteger();
    private final SocketChannelWrapperFactory socketChannelWrapperFactory;
    private final ClientExecutionServiceImpl executionService;
    private final ConcurrentMap<Address, ClientConnection> connections = new ConcurrentHashMap<Address, ClientConnection>();
    private volatile boolean live = false;

    public ClientConnectionManagerImpl(HazelcastClient client, LoadBalancer loadBalancer) {
        String credentialsClassname;
        this.client = client;
        ClientConfig config = client.getClientConfig();
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        GroupConfig groupConfig = config.getGroupConfig();
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        Credentials c = securityConfig.getCredentials();
        if (c == null && (credentialsClassname = securityConfig.getCredentialsClassname()) != null) {
            try {
                c = (Credentials)ClassLoaderUtil.newInstance(config.getClassLoader(), credentialsClassname);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (c == null) {
            c = new UsernamePasswordCredentials(groupConfig.getName(), groupConfig.getPassword());
        }
        this.smartRouting = networkConfig.isSmartRouting();
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.credentials = c;
        this.router = new Router(loadBalancer);
        this.inSelector = new ClientInSelectorImpl(client.getThreadGroup());
        this.outSelector = new ClientOutSelectorImpl(client.getThreadGroup());
        SocketInterceptorConfig sic = networkConfig.getSocketInterceptorConfig();
        SocketInterceptor implementation = null;
        if (sic != null && sic.isEnabled() && (implementation = (SocketInterceptor)sic.getImplementation()) == null && sic.getClassName() != null) {
            try {
                implementation = (SocketInterceptor)Class.forName(sic.getClassName()).newInstance();
            }
            catch (Throwable e) {
                logger.severe("SocketInterceptor class cannot be instantiated!" + sic.getClassName(), e);
            }
        }
        this.socketInterceptor = implementation;
        if (this.socketInterceptor != null) {
            logger.info("SocketInterceptor is enabled");
            this.socketInterceptor.init(sic.getProperties());
        }
        this.socketOptions = networkConfig.getSocketOptions();
        SSLConfig sslConfig = networkConfig.getSSLConfig();
        if (sslConfig != null && sslConfig.isEnabled()) {
            this.socketChannelWrapperFactory = new SSLSocketChannelWrapperFactory(sslConfig);
            logger.info("SSL is enabled");
        } else {
            this.socketChannelWrapperFactory = new DefaultSocketChannelWrapperFactory();
        }
    }

    public boolean isLive() {
        return this.live;
    }

    public SerializationContext getSerializationContext() {
        return this.client.getSerializationService().getSerializationContext();
    }

    public SerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    @Override
    public synchronized void start() {
        if (this.live) {
            return;
        }
        this.live = true;
        this.inSelector.start();
        this.outSelector.start();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.live) {
            return;
        }
        this.live = false;
        for (ClientConnection connection : this.connections.values()) {
            connection.close();
        }
        this.inSelector.shutdown();
        this.outSelector.shutdown();
        this.connectionLockMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markOwnerAddressAsClosed() {
        Object object = this.ownerConnectionLock;
        synchronized (object) {
            this.ownerConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address waitForOwnerConnection() throws RetryableIOException {
        if (this.ownerConnection != null) {
            return this.ownerConnection.getRemoteEndpoint();
        }
        Object object = this.ownerConnectionLock;
        synchronized (object) {
            ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
            int connectionAttemptLimit = networkConfig.getConnectionAttemptLimit();
            int connectionAttemptPeriod = networkConfig.getConnectionAttemptPeriod();
            int waitTime = connectionAttemptLimit * connectionAttemptPeriod * 2;
            while (this.ownerConnection == null) {
                try {
                    this.ownerConnectionLock.wait(waitTime);
                }
                catch (InterruptedException e) {
                    logger.warning("Wait for owner connection is timed out");
                    throw new RetryableIOException(e);
                }
            }
            return this.ownerConnection.getRemoteEndpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientConnection ownerConnection(Address address) throws Exception {
        ManagerAuthenticator authenticator = new ManagerAuthenticator();
        ConnectionProcessor connectionProcessor = new ConnectionProcessor(address, authenticator, true);
        ICompletableFuture<ClientConnection> future = this.executionService.submitInternal(connectionProcessor);
        try {
            this.ownerConnection = (ClientConnection)future.get(5L, TimeUnit.SECONDS);
            Object object = this.ownerConnectionLock;
            synchronized (object) {
                this.ownerConnectionLock.notifyAll();
            }
            return this.ownerConnection;
        }
        catch (Exception e) {
            future.cancel(true);
            throw new RetryableIOException(e);
        }
    }

    @Override
    public ClientConnection tryToConnect(Address target) throws Exception {
        ClusterAuthenticator authenticator = new ClusterAuthenticator();
        IOException lastError = null;
        for (int count = 0; count < this.RETRY_COUNT; ++count) {
            try {
                if (target == null || !this.isMember(target)) {
                    Address address = this.getAddressFromLoadBalancer();
                    return this.getOrConnect(address, authenticator);
                }
                return this.getOrConnect(target, authenticator);
            }
            catch (IOException e) {
                lastError = e;
                target = null;
                continue;
            }
        }
        throw lastError;
    }

    private Address getAddressFromLoadBalancer() {
        Address address = this.router.next();
        if (address == null) {
            Set<Member> members = this.client.getCluster().getMembers();
            String msg = members.isEmpty() ? "No address was return by the LoadBalancer since there are no members in the cluster" : "No address was return by the LoadBalancer. But the cluster contains the following members:" + members;
            throw new IllegalStateException(msg);
        }
        return address;
    }

    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    private boolean isMember(Address target) {
        ClientClusterService clientClusterService = this.client.getClientClusterService();
        return clientClusterService.getMember(target) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnection getOrConnect(Address address, Authenticator authenticator) throws Exception {
        ClientConnection clientConnection;
        if (address == null) {
            throw new NullPointerException("Address is required!");
        }
        if (!this.smartRouting) {
            address = this.waitForOwnerConnection();
        }
        if ((clientConnection = (ClientConnection)this.connections.get(address)) == null) {
            Object lock;
            Object object = lock = this.getLock(address);
            synchronized (object) {
                clientConnection = (ClientConnection)this.connections.get(address);
                if (clientConnection == null) {
                    ConnectionProcessor connectionProcessor = new ConnectionProcessor(address, authenticator, false);
                    ICompletableFuture<ClientConnection> future = this.executionService.submitInternal(connectionProcessor);
                    try {
                        clientConnection = (ClientConnection)future.get(5L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        future.cancel(true);
                        throw new RetryableIOException(e);
                    }
                    ClientConnection current = this.connections.putIfAbsent(clientConnection.getRemoteEndpoint(), clientConnection);
                    if (current != null) {
                        clientConnection.innerClose();
                        clientConnection = current;
                    }
                }
            }
        }
        return clientConnection;
    }

    public void destroyConnection(ClientConnection clientConnection) {
        Address endpoint = clientConnection.getRemoteEndpoint();
        if (endpoint != null) {
            this.connections.remove(clientConnection.getRemoteEndpoint());
            this.closeIfOwnerConnection(endpoint);
        }
    }

    private void closeIfOwnerConnection(Address endpoint) {
        ClientConnection currentOwnerConnection = this.ownerConnection;
        if (currentOwnerConnection == null || !currentOwnerConnection.live()) {
            return;
        }
        if (endpoint.equals(currentOwnerConnection.getRemoteEndpoint())) {
            try {
                currentOwnerConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean removeEventHandler(Integer callId) {
        if (callId != null) {
            for (ClientConnection clientConnection : this.connections.values()) {
                if (clientConnection.deRegisterEventHandler(callId) == null) continue;
                return true;
            }
        }
        return false;
    }

    public void handlePacket(ClientPacket packet) {
        ClientConnection conn = (ClientConnection)packet.getConn();
        conn.incrementPacketCount();
        this.executionService.executeInternal(new ClientPacketProcessor(packet));
    }

    public int newCallId() {
        return this.callIdIncrementer.incrementAndGet();
    }

    private Object authenticate(ClientConnection connection, Credentials credentials, ClientPrincipal principal, boolean reAuth, boolean firstConnection) throws IOException {
        SerializableCollection collectionWrapper;
        SerializationService ss = this.getSerializationService();
        AuthenticationRequest auth = new AuthenticationRequest(credentials, principal);
        connection.init();
        auth.setReAuth(reAuth);
        auth.setFirstConnection(firstConnection);
        try {
            collectionWrapper = (SerializableCollection)this.sendAndReceive(auth, connection);
        }
        catch (Exception e) {
            throw new RetryableIOException(e);
        }
        Iterator<Data> iter = collectionWrapper.iterator();
        if (iter.hasNext()) {
            Data addressData = iter.next();
            Address address = (Address)ss.toObject(addressData);
            connection.setRemoteEndpoint(address);
            if (iter.hasNext()) {
                Data principalData = iter.next();
                return ss.toObject(principalData);
            }
        }
        throw new AuthenticationException();
    }

    public Object sendAndReceive(ClientRequest request, ClientConnection connection) throws Exception {
        SerializationService ss = this.client.getSerializationService();
        connection.write(ss.toData(request));
        Data data = connection.read();
        ClientResponse clientResponse = (ClientResponse)ss.toObject(data);
        Object response = ss.toObject(clientResponse.getResponse());
        if (response instanceof Throwable) {
            Throwable t = (Throwable)response;
            ExceptionUtil.fixRemoteStackTrace(t, Thread.currentThread().getStackTrace());
            throw new Exception(t);
        }
        return response;
    }

    private Object getLock(Address address) {
        Object current;
        Object lock = this.connectionLockMap.get(address);
        if (lock == null && (current = this.connectionLockMap.putIfAbsent(address, lock = new Object())) != null) {
            lock = current;
        }
        return lock;
    }

    static class SSLSocketChannelWrapperFactory
    implements SocketChannelWrapperFactory {
        final SSLContextFactory sslContextFactory;

        SSLSocketChannelWrapperFactory(SSLConfig sslConfig) {
            SSLContextFactory sslContextFactoryObject = (SSLContextFactory)sslConfig.getFactoryImplementation();
            try {
                String factoryClassName = sslConfig.getFactoryClassName();
                if (sslContextFactoryObject == null && factoryClassName != null) {
                    sslContextFactoryObject = (SSLContextFactory)Class.forName(factoryClassName).newInstance();
                }
                if (sslContextFactoryObject == null) {
                    sslContextFactoryObject = new BasicSSLContextFactory();
                }
                sslContextFactoryObject.init(sslConfig.getProperties());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.sslContextFactory = sslContextFactoryObject;
        }

        @Override
        public SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
            return new SSLSocketChannelWrapper(this.sslContextFactory.getSSLContext(), socketChannel, client);
        }
    }

    static class DefaultSocketChannelWrapperFactory
    implements SocketChannelWrapperFactory {
        DefaultSocketChannelWrapperFactory() {
        }

        @Override
        public SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
            return new DefaultSocketChannelWrapper(socketChannel);
        }
    }

    static interface SocketChannelWrapperFactory {
        public SocketChannelWrapper wrapSocketChannel(SocketChannel var1, boolean var2) throws Exception;
    }

    private class ClusterAuthenticator
    implements Authenticator {
        private ClusterAuthenticator() {
        }

        @Override
        public void auth(ClientConnection connection) throws AuthenticationException, IOException {
            ClientConnectionManagerImpl.this.authenticate(connection, ClientConnectionManagerImpl.this.credentials, ClientConnectionManagerImpl.this.principal, false, false);
        }
    }

    public class ManagerAuthenticator
    implements Authenticator {
        @Override
        public void auth(ClientConnection connection) throws AuthenticationException, IOException {
            Object response = ClientConnectionManagerImpl.this.authenticate(connection, ClientConnectionManagerImpl.this.credentials, ClientConnectionManagerImpl.this.principal, true, true);
            ClientConnectionManagerImpl.this.principal = (ClientPrincipal)response;
        }
    }

    private class ClientPacketProcessor
    implements Runnable {
        final ClientPacket packet;

        ClientPacketProcessor(ClientPacket packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            ClientConnection conn = (ClientConnection)this.packet.getConn();
            ClientResponse clientResponse = (ClientResponse)ClientConnectionManagerImpl.this.getSerializationService().toObject(this.packet.getData());
            int callId = clientResponse.getCallId();
            Data response = clientResponse.getResponse();
            if (clientResponse.isEvent()) {
                ClientConnectionManagerImpl.this.executionService.execute(new ClientEventProcessor(callId, conn, response));
            } else {
                this.handlePacket(response, clientResponse.isError(), callId, conn);
            }
            conn.decrementPacketCount();
        }

        private void handlePacket(Object response, boolean isError, int callId, ClientConnection conn) {
            ClientCallFuture future = conn.deRegisterCallId(callId);
            if (future == null) {
                logger.warning("No call for callId: " + callId + ", response: " + response);
                return;
            }
            if (isError) {
                response = ClientConnectionManagerImpl.this.getSerializationService().toObject(response);
            }
            future.notify(response);
        }
    }

    private class ClientEventProcessor
    implements Runnable {
        final int callId;
        final ClientConnection conn;
        final Data response;

        private ClientEventProcessor(int callId, ClientConnection conn, Data response) {
            this.callId = callId;
            this.conn = conn;
            this.response = response;
        }

        @Override
        public void run() {
            this.handleEvent(this.response, this.callId, this.conn);
        }

        private void handleEvent(Data event, int callId, ClientConnection conn) {
            EventHandler eventHandler = conn.getEventHandler(callId);
            Object eventObject = ClientConnectionManagerImpl.this.getSerializationService().toObject(event);
            if (eventHandler == null) {
                logger.warning("No eventHandler for callId: " + callId + ", event: " + eventObject + ", conn: " + conn);
                return;
            }
            eventHandler.handle(eventObject);
        }
    }

    private class ConnectionProcessor
    implements Callable<ClientConnection> {
        final Address address;
        final Authenticator authenticator;
        final boolean isBlock;

        private ConnectionProcessor(Address address, Authenticator authenticator, boolean isBlock) {
            this.address = address;
            this.authenticator = authenticator;
            this.isBlock = isBlock;
        }

        @Override
        public ClientConnection call() throws Exception {
            if (!ClientConnectionManagerImpl.this.live) {
                throw new HazelcastException("ConnectionManager is not active!!!");
            }
            SocketChannel socketChannel = null;
            try {
                int bufferSize;
                socketChannel = SocketChannel.open();
                Socket socket = socketChannel.socket();
                socket.setKeepAlive(ClientConnectionManagerImpl.this.socketOptions.isKeepAlive());
                socket.setTcpNoDelay(ClientConnectionManagerImpl.this.socketOptions.isTcpNoDelay());
                socket.setReuseAddress(ClientConnectionManagerImpl.this.socketOptions.isReuseAddress());
                if (ClientConnectionManagerImpl.this.socketOptions.getLingerSeconds() > 0) {
                    socket.setSoLinger(true, ClientConnectionManagerImpl.this.socketOptions.getLingerSeconds());
                }
                if ((bufferSize = ClientConnectionManagerImpl.this.socketOptions.getBufferSize() * 1024) < 0) {
                    bufferSize = 16384;
                }
                socket.setSendBufferSize(bufferSize);
                socket.setReceiveBufferSize(bufferSize);
                socketChannel.socket().connect(this.address.getInetSocketAddress(), 5000);
                SocketChannelWrapper socketChannelWrapper = ClientConnectionManagerImpl.this.socketChannelWrapperFactory.wrapSocketChannel(socketChannel, true);
                ClientConnection clientConnection = new ClientConnection(ClientConnectionManagerImpl.this, ClientConnectionManagerImpl.this.inSelector, ClientConnectionManagerImpl.this.outSelector, ClientConnectionManagerImpl.this.connectionIdGen.incrementAndGet(), socketChannelWrapper, ClientConnectionManagerImpl.this.executionService);
                socketChannel.configureBlocking(true);
                if (ClientConnectionManagerImpl.this.socketInterceptor != null) {
                    ClientConnectionManagerImpl.this.socketInterceptor.onConnect(socket);
                }
                this.authenticator.auth(clientConnection);
                socketChannel.configureBlocking(this.isBlock);
                socket.setSoTimeout(0);
                if (!this.isBlock) {
                    clientConnection.getReadHandler().register();
                }
                return clientConnection;
            }
            catch (Exception e) {
                if (socketChannel != null) {
                    socketChannel.close();
                }
                throw ExceptionUtil.rethrow(e);
            }
        }
    }
}

