/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.util.ThreadUtil;
import java.io.IOException;

public abstract class BaseTransactionRequest
extends CallableClientRequest {
    protected String txnId;
    protected long clientThreadId;

    protected abstract Object innerCall() throws Exception;

    public final Object call() throws Exception {
        ThreadUtil.setThreadId(this.clientThreadId);
        try {
            Object object = this.innerCall();
            return object;
        }
        finally {
            ThreadUtil.removeThreadId();
        }
    }

    public void setTxnId(String txnId) {
        this.txnId = txnId;
    }

    public void setClientThreadId(long clientThreadId) {
        this.clientThreadId = clientThreadId;
    }

    protected TransactionContext getTransactionContext() {
        ClientEndpoint endpoint = this.getEndpoint();
        TransactionContext transactionContext = endpoint.getTransactionContext(this.txnId);
        if (transactionContext == null) {
            throw new TransactionException("No transaction context with given transactionId: " + this.txnId);
        }
        return transactionContext;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("tId", this.txnId);
        writer.writeLong("cti", this.clientThreadId);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.txnId = reader.readUTF("tId");
        this.clientThreadId = reader.readLong("cti");
    }
}

