/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.core.Member;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.query.MapQueryEngine;
import com.hazelcast.map.impl.query.QueryOperation;
import com.hazelcast.map.impl.query.QueryPartitionOperation;
import com.hazelcast.map.impl.query.QueryResult;
import com.hazelcast.map.impl.query.QueryResultRow;
import com.hazelcast.map.impl.query.QueryResultSizeLimiter;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PagingPredicateAccessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class MapQueryEngineImpl
implements MapQueryEngine {
    protected static final long QUERY_EXECUTION_TIMEOUT_MINUTES = 5L;
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final ILogger logger;
    protected final QueryResultSizeLimiter queryResultSizeLimiter;
    protected final SerializationService serializationService;
    protected final InternalPartitionService partitionService;
    protected final QueryOptimizer queryOptimizer;
    protected final OperationService operationService;
    protected final ClusterService clusterService;
    protected final LocalMapStatsProvider localMapStatsProvider;
    protected final boolean parallelEvaluation;
    protected final ManagedExecutorService executor;

    public MapQueryEngineImpl(MapServiceContext mapServiceContext, QueryOptimizer optimizer) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.serializationService = this.nodeEngine.getSerializationService();
        this.partitionService = this.nodeEngine.getPartitionService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.queryResultSizeLimiter = new QueryResultSizeLimiter(mapServiceContext, this.logger);
        this.queryOptimizer = optimizer;
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
        this.localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
        this.parallelEvaluation = this.nodeEngine.getGroupProperties().getBoolean(GroupProperty.QUERY_PREDICATE_PARALLEL_EVALUATION);
        this.executor = this.nodeEngine.getExecutionService().getExecutor("hz:query");
    }

    QueryResultSizeLimiter getQueryResultSizeLimiter() {
        return this.queryResultSizeLimiter;
    }

    @Override
    public QueryResult queryLocalPartitions(String mapName, Predicate predicate, IterationType iterationType) throws ExecutionException, InterruptedException {
        int initialPartitionStateVersion = this.partitionService.getPartitionStateVersion();
        Collection<Integer> initialPartitions = this.mapServiceContext.getOwnedPartitions();
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        QueryResult result = this.tryQueryUsingIndexes(predicate = this.queryOptimizer.optimize(predicate, mapContainer.getIndexes()), initialPartitions, mapContainer, iterationType);
        if (result == null) {
            result = this.queryUsingFullTableScan(mapName, predicate, initialPartitions, iterationType);
        }
        if (this.hasPartitionVersion(initialPartitionStateVersion, predicate)) {
            result.setPartitionIds(initialPartitions);
        }
        this.updateStatistics(mapContainer);
        return result;
    }

    protected QueryResult tryQueryUsingIndexes(Predicate predicate, Collection<Integer> partitions, MapContainer mapContainer, IterationType iterationType) {
        if (this.partitionService.hasOnGoingMigrationLocal()) {
            return null;
        }
        Set<QueryableEntry> entries = mapContainer.getIndexes().query(predicate);
        if (entries == null) {
            return null;
        }
        QueryResult result = this.newQueryResult(partitions.size(), iterationType);
        result.addAll(entries);
        return result;
    }

    protected void updateStatistics(MapContainer mapContainer) {
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            LocalMapStatsImpl localStats = this.localMapStatsProvider.getLocalMapStatsImpl(mapContainer.getName());
            localStats.incrementOtherOperations();
        }
    }

    protected QueryResult queryUsingFullTableScan(String name, Predicate predicate, Collection<Integer> partitions, IterationType iterationType) throws InterruptedException, ExecutionException {
        if (predicate instanceof PagingPredicate) {
            return this.queryParallelForPaging(name, (PagingPredicate)predicate, partitions, iterationType);
        }
        if (this.parallelEvaluation) {
            return this.queryParallel(name, predicate, partitions, iterationType);
        }
        return this.querySequential(name, predicate, partitions, iterationType);
    }

    protected QueryResult querySequential(String name, Predicate predicate, Collection<Integer> partitions, IterationType iterationType) {
        QueryResult result = this.newQueryResult(partitions.size(), iterationType);
        RetryableHazelcastException storedException = null;
        for (Integer partitionId : partitions) {
            try {
                Collection<QueryableEntry> entries = this.queryTheLocalPartition(name, predicate, partitionId);
                result.addAll(entries);
            }
            catch (RetryableHazelcastException e) {
                if (storedException != null) continue;
                storedException = e;
            }
        }
        if (storedException != null) {
            throw storedException;
        }
        return result;
    }

    protected QueryResult queryParallel(String name, Predicate predicate, Collection<Integer> partitions, IterationType iterationType) throws InterruptedException, ExecutionException {
        QueryResult result = this.newQueryResult(partitions.size(), iterationType);
        ArrayList<Future<Collection<QueryableEntry>>> futures = new ArrayList<Future<Collection<QueryableEntry>>>(partitions.size());
        for (Integer partitionId : partitions) {
            QueryPartitionCallable task = new QueryPartitionCallable(name, predicate, partitionId);
            Future<Collection<QueryableEntry>> future = this.executor.submit(task);
            futures.add(future);
        }
        Collection<Collection<QueryableEntry>> returnedResults = MapQueryEngineImpl.getResult(futures);
        for (Collection<QueryableEntry> returnedResult : returnedResults) {
            if (returnedResult == null) continue;
            result.addAll(returnedResult);
        }
        return result;
    }

    protected QueryResult queryParallelForPaging(String name, PagingPredicate predicate, Collection<Integer> partitions, IterationType iterationType) throws InterruptedException, ExecutionException {
        QueryResult result = this.newQueryResult(partitions.size(), iterationType);
        ArrayList<Future<Collection<QueryableEntry>>> futures = new ArrayList<Future<Collection<QueryableEntry>>>(partitions.size());
        for (Integer partitionId : partitions) {
            QueryPartitionCallable task = new QueryPartitionCallable(name, predicate, partitionId);
            Future future = this.executor.submit(task);
            futures.add(future);
        }
        LinkedList<QueryableEntry> toMerge = new LinkedList<QueryableEntry>();
        Collection<Collection<QueryableEntry>> returnedResults = MapQueryEngineImpl.getResult(futures);
        for (Collection collection : returnedResults) {
            toMerge.addAll(collection);
        }
        Map.Entry<Integer, Map.Entry> nearestAnchorEntry = PagingPredicateAccessor.getNearestAnchorEntry(predicate);
        List<QueryableEntry> list = SortingUtil.getSortedSubList(toMerge, predicate, nearestAnchorEntry);
        result.addAll(list);
        return result;
    }

    protected static Collection<Collection<QueryableEntry>> getResult(List<Future<Collection<QueryableEntry>>> lsFutures) {
        return FutureUtil.returnWithDeadline(lsFutures, 5L, TimeUnit.MINUTES, FutureUtil.RETHROW_EVERYTHING);
    }

    protected boolean hasPartitionVersion(int expectedVersion, Predicate predicate) {
        if (expectedVersion != this.partitionService.getPartitionStateVersion()) {
            this.logger.info("Partition assignments changed while executing query: " + predicate);
            return false;
        }
        return true;
    }

    protected Collection<QueryableEntry> queryTheLocalPartition(String mapName, Predicate predicate, int partitionId) {
        PagingPredicate pagingPredicate = predicate instanceof PagingPredicate ? (PagingPredicate)predicate : null;
        LinkedList<QueryableEntry> resultList = new LinkedList<QueryableEntry>();
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        Iterator<Record> iterator = partitionContainer.getRecordStore(mapName).loadAwareIterator(this.getNow(), false);
        Map.Entry<Integer, Map.Entry> nearestAnchorEntry = PagingPredicateAccessor.getNearestAnchorEntry(pagingPredicate);
        boolean useCachedVersion = this.shouldUseCachedValue(mapContainer);
        Extractors extractors = this.mapServiceContext.getExtractors(mapName);
        while (iterator.hasNext()) {
            Data key;
            CachedQueryEntry queryEntry;
            Record record = iterator.next();
            Object value = useCachedVersion ? Records.getValueOrCachedValue(record, this.serializationService) : record.getValue();
            if (value == null || !predicate.apply(queryEntry = new CachedQueryEntry(this.serializationService, key = record.getKey(), value, extractors)) || !SortingUtil.compareAnchor(pagingPredicate, queryEntry, nearestAnchorEntry)) continue;
            resultList.add(queryEntry);
        }
        return SortingUtil.getSortedSubList(resultList, pagingPredicate, nearestAnchorEntry);
    }

    private boolean shouldUseCachedValue(MapContainer mapContainer) {
        CacheDeserializedValues cacheDeserializedValues = mapContainer.getMapConfig().getCacheDeserializedValues();
        switch (cacheDeserializedValues) {
            case NEVER: {
                return false;
            }
            case ALWAYS: {
                return true;
            }
        }
        return mapContainer.getIndexes().hasIndex();
    }

    @Override
    public QueryResult queryLocalPartition(String mapName, Predicate predicate, int partitionId, IterationType iterationType) {
        Collection<QueryableEntry> queryableEntries = this.queryTheLocalPartition(mapName, predicate, partitionId);
        QueryResult result = this.newQueryResult(1, iterationType);
        result.addAll(queryableEntries);
        result.setPartitionIds(Collections.singletonList(partitionId));
        return result;
    }

    @Override
    public QueryResult invokeQueryLocalPartitions(String mapName, Predicate predicate, IterationType iterationType) {
        this.checkNotPagingPredicate(predicate);
        List<Integer> partitionIds = this.getLocalPartitionIds();
        QueryResult result = this.newQueryResult(partitionIds.size(), iterationType);
        try {
            Future<QueryResult> future = this.queryOnLocalMember(mapName, predicate, iterationType);
            List<Future<QueryResult>> futures = Collections.singletonList(future);
            this.addResultsOfPredicate(futures, result, partitionIds);
            if (partitionIds.isEmpty()) {
                return result;
            }
        }
        catch (Throwable t) {
            if (t.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t);
            }
            this.logger.warning("Could not get results", t);
        }
        try {
            List<Future<QueryResult>> futures = this.queryPartitions(mapName, predicate, partitionIds, iterationType);
            this.addResultsOfPredicate(futures, result, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    @Override
    public Set queryLocalPartitionsWithPagingPredicate(String mapName, PagingPredicate predicate, IterationType iterationType) {
        predicate.setIterationType(iterationType);
        ArrayList<Map.Entry> resultList = new ArrayList<Map.Entry>();
        List<Integer> partitionIds = this.getLocalPartitionIds();
        IterationType retrievalIterationType = iterationType == IterationType.VALUE ? IterationType.ENTRY : iterationType;
        try {
            Future<QueryResult> future = this.queryOnLocalMember(mapName, predicate, retrievalIterationType);
            List<Future<QueryResult>> futures = Collections.singletonList(future);
            this.addResultsOfPagingPredicate(futures, resultList, partitionIds);
            if (partitionIds.isEmpty()) {
                return SortingUtil.getSortedQueryResultSet(resultList, predicate, iterationType);
            }
        }
        catch (Throwable t) {
            if (t.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t);
            }
            this.logger.warning("Could not get results", t);
        }
        try {
            List<Future<QueryResult>> futures = this.queryPartitions(mapName, predicate, partitionIds, retrievalIterationType);
            this.addResultsOfPagingPredicate(futures, resultList, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return SortingUtil.getSortedQueryResultSet(resultList, predicate, iterationType);
    }

    @Override
    public Set queryAllPartitionsWithPagingPredicate(String mapName, PagingPredicate predicate, IterationType iterationType) {
        List<Future<QueryResult>> futures;
        predicate.setIterationType(iterationType);
        ArrayList<Map.Entry> resultList = new ArrayList<Map.Entry>();
        Set<Integer> partitionIds = this.getAllPartitionIds();
        IterationType retrievalIterationType = iterationType == IterationType.VALUE ? IterationType.ENTRY : iterationType;
        try {
            futures = this.queryOnMembers(mapName, predicate, retrievalIterationType);
            this.addResultsOfPagingPredicate(futures, resultList, partitionIds);
            if (partitionIds.isEmpty()) {
                return SortingUtil.getSortedQueryResultSet(resultList, predicate, iterationType);
            }
        }
        catch (Throwable t) {
            if (t.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t);
            }
            this.logger.warning("Could not get results", t);
        }
        try {
            futures = this.queryPartitions(mapName, predicate, partitionIds, retrievalIterationType);
            this.addResultsOfPagingPredicate(futures, resultList, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return SortingUtil.getSortedQueryResultSet(resultList, predicate, iterationType);
    }

    @Override
    public QueryResult invokeQueryAllPartitions(String mapName, Predicate predicate, IterationType iterationType) {
        List<Future<QueryResult>> futures;
        this.checkNotPagingPredicate(predicate);
        if (predicate == TruePredicate.INSTANCE) {
            this.queryResultSizeLimiter.checkMaxResultLimitOnLocalPartitions(mapName);
        }
        Set<Integer> partitionIds = this.getAllPartitionIds();
        QueryResult result = this.newQueryResult(partitionIds.size(), iterationType);
        try {
            futures = this.queryOnMembers(mapName, predicate, iterationType);
            this.addResultsOfPredicate(futures, result, partitionIds);
            if (partitionIds.isEmpty()) {
                return result;
            }
        }
        catch (Throwable t) {
            if (t.getCause() instanceof QueryResultSizeExceededException) {
                throw ExceptionUtil.rethrow(t);
            }
            this.logger.warning("Could not get results", t);
        }
        try {
            futures = this.queryPartitions(mapName, predicate, partitionIds, iterationType);
            this.addResultsOfPredicate(futures, result, partitionIds);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    protected QueryResult newQueryResult(int numberOfPartitions, IterationType iterationType) {
        return new QueryResult(iterationType, this.queryResultSizeLimiter.getNodeResultLimit(numberOfPartitions));
    }

    protected void checkNotPagingPredicate(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            throw new IllegalArgumentException("Predicate should not be a paging predicate");
        }
    }

    protected Future<QueryResult> queryOnLocalMember(String mapName, Predicate predicate, IterationType iterationType) {
        QueryOperation operation = new QueryOperation(mapName, predicate, iterationType);
        return this.operationService.invokeOnTarget("hz:impl:mapService", operation, this.nodeEngine.getThisAddress());
    }

    protected List<Future<QueryResult>> queryOnMembers(String mapName, Predicate predicate, IterationType iterationType) {
        Set<Member> members = this.clusterService.getMembers();
        ArrayList<Future<QueryResult>> futures = new ArrayList<Future<QueryResult>>(members.size());
        for (Member member : members) {
            QueryOperation operation = new QueryOperation(mapName, predicate, iterationType);
            InternalCompletableFuture future = this.operationService.invokeOnTarget("hz:impl:mapService", operation, member.getAddress());
            futures.add(future);
        }
        return futures;
    }

    protected List<Future<QueryResult>> queryPartitions(String mapName, Predicate predicate, Collection<Integer> partitionIds, IterationType iterationType) {
        if (partitionIds == null || partitionIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Future<QueryResult>> futures = new ArrayList<Future<QueryResult>>(partitionIds.size());
        for (Integer partitionId : partitionIds) {
            QueryPartitionOperation op = new QueryPartitionOperation(mapName, predicate, iterationType);
            op.setPartitionId(partitionId);
            try {
                InternalCompletableFuture future = this.operationService.invokeOnPartition("hz:impl:mapService", op, partitionId);
                futures.add(future);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
        return futures;
    }

    protected void addResultsOfPagingPredicate(List<Future<QueryResult>> futures, Collection result, Collection<Integer> partitionIds) throws ExecutionException, InterruptedException {
        for (Future<QueryResult> future : futures) {
            Collection<Integer> tmpPartitionIds;
            QueryResult queryResult = future.get();
            if (queryResult == null || (tmpPartitionIds = queryResult.getPartitionIds()) == null) continue;
            partitionIds.removeAll(tmpPartitionIds);
            for (QueryResultRow row : queryResult.getRows()) {
                Object key = this.toObject(row.getKey());
                Object value = this.toObject(row.getValue());
                result.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value));
            }
        }
    }

    protected void addResultsOfPredicate(List<Future<QueryResult>> futures, QueryResult result, Collection<Integer> partitionIds) throws ExecutionException, InterruptedException {
        for (Future<QueryResult> future : futures) {
            Collection<Integer> queriedPartitionIds;
            QueryResult queryResult = future.get();
            if (queryResult == null || (queriedPartitionIds = queryResult.getPartitionIds()) == null) continue;
            partitionIds.removeAll(queriedPartitionIds);
            result.addAllRows(queryResult.getRows());
        }
    }

    protected Object toObject(Object obj) {
        return this.serializationService.toObject(obj);
    }

    protected List<Integer> getLocalPartitionIds() {
        return this.partitionService.getMemberPartitions(this.nodeEngine.getThisAddress());
    }

    protected Set<Integer> getAllPartitionIds() {
        int partitionCount = this.partitionService.getPartitionCount();
        return this.createSetWithPopulatedPartitionIds(partitionCount);
    }

    protected Set<Integer> createSetWithPopulatedPartitionIds(int partitionCount) {
        HashSet<Integer> partitionIds = new HashSet<Integer>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            partitionIds.add(i);
        }
        return partitionIds;
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }

    protected final class QueryPartitionCallable
    implements Callable<Collection<QueryableEntry>> {
        protected final int partition;
        protected final String name;
        protected final Predicate predicate;

        protected QueryPartitionCallable(String name, Predicate predicate, int partitionId) {
            this.name = name;
            this.predicate = predicate;
            this.partition = partitionId;
        }

        @Override
        public Collection<QueryableEntry> call() throws Exception {
            MapQueryEngineImpl queryEngine = (MapQueryEngineImpl)MapQueryEngineImpl.this.mapServiceContext.getMapQueryEngine(this.name);
            return queryEngine.queryTheLocalPartition(this.name, this.predicate, this.partition);
        }
    }
}

