/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.nearcache.impl.store;

import com.hazelcast.cache.impl.nearcache.NearCacheRecord;
import com.hazelcast.cache.impl.nearcache.impl.SampleableNearCacheRecordMap;
import com.hazelcast.internal.eviction.Evictable;
import com.hazelcast.internal.eviction.EvictionCandidate;
import com.hazelcast.internal.eviction.EvictionListener;
import com.hazelcast.util.SampleableConcurrentHashMap;

public class HeapNearCacheRecordMap<K, V extends NearCacheRecord>
extends SampleableConcurrentHashMap<K, V>
implements SampleableNearCacheRecordMap<K, V> {
    public HeapNearCacheRecordMap(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    protected <E extends SampleableConcurrentHashMap.SamplingEntry> E createSamplingEntry(K key, V value) {
        return (E)new EvictableSamplingEntry(this, key, value);
    }

    @Override
    public <C extends EvictionCandidate<K, V>> int evict(Iterable<C> evictionCandidates, EvictionListener<K, V> evictionListener) {
        if (evictionCandidates == null) {
            return 0;
        }
        int actualEvictedCount = 0;
        for (EvictionCandidate evictionCandidate : evictionCandidates) {
            if (this.remove(evictionCandidate.getAccessor()) == null) continue;
            ++actualEvictedCount;
            if (evictionListener == null) continue;
            evictionListener.onEvict(evictionCandidate.getAccessor(), evictionCandidate.getEvictable());
        }
        return actualEvictedCount;
    }

    @Override
    public Iterable<EvictableSamplingEntry> sample(int sampleCount) {
        return super.getRandomSamples(sampleCount);
    }

    public static class EvictableSamplingEntry
    extends SampleableConcurrentHashMap.SamplingEntry
    implements EvictionCandidate {
        final /* synthetic */ HeapNearCacheRecordMap this$0;

        public EvictableSamplingEntry(K key, V value) {
            this.this$0 = this$0;
            super(this$0, key, value);
        }

        public Object getAccessor() {
            return this.getKey();
        }

        public Evictable getEvictable() {
            return (Evictable)this.getValue();
        }
    }
}

