/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitors;

import com.hazelcast.core.Member;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.management.dto.SlowOperationDTO;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.renderers.CommaSeparatedKeyValueProbeRenderer;
import com.hazelcast.internal.metrics.renderers.HumanFriendlyProbeRenderer;
import com.hazelcast.internal.metrics.renderers.ProbeRenderer;
import com.hazelcast.internal.monitors.PerformanceMonitor;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

final class PerformanceLogFile {
    private static final int ONE_MB = 0x100000;
    volatile File logFile;
    private final MetricsRegistry metricRegistry;
    private final HazelcastInstanceImpl hazelcastInstance;
    private final InternalOperationService operationService;
    private final ILogger logger;
    private final HeadRenderer headRenderer = new HeadRenderer();
    private final BodyRenderer bodyRenderer;
    private final String pathname;
    private long lastModified;
    private int index;
    private BufferedWriter writer;
    private boolean renderHead;
    private int maxRollingFileCount;
    private int maxRollingFileSizeBytes;

    PerformanceLogFile(PerformanceMonitor performanceMonitor) {
        this.bodyRenderer = new BodyRenderer(performanceMonitor.humanFriendlyFormat);
        this.logger = performanceMonitor.logger;
        this.hazelcastInstance = performanceMonitor.hazelcastInstance;
        Node node = this.hazelcastInstance.node;
        this.metricRegistry = node.nodeEngine.getMetricsRegistry();
        this.operationService = node.nodeEngine.getOperationService();
        this.pathname = this.getPathName();
        GroupProperties props = node.getGroupProperties();
        this.maxRollingFileCount = props.getInteger(GroupProperty.PERFORMANCE_MONITOR_MAX_ROLLED_FILE_COUNT);
        this.maxRollingFileSizeBytes = Math.round(1048576.0f * props.getFloat(GroupProperty.PERFORMANCE_MONITOR_MAX_ROLLED_FILE_SIZE_MB));
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("max rolling file size: " + this.maxRollingFileSizeBytes);
            this.logger.finest("max rolling file count: " + this.maxRollingFileCount);
        }
    }

    private String getPathName() {
        Member localMember = this.hazelcastInstance.getCluster().getLocalMember();
        Address address = localMember.getAddress();
        String addressString = address.getHost().replace(":", "_") + "#" + address.getPort();
        return "performance-" + addressString + "-" + System.currentTimeMillis() + "-%03d.log";
    }

    void render() {
        try {
            if (this.logFile == null) {
                this.logFile = new File(String.format(this.pathname, this.index));
                this.renderHead = true;
            }
            if (this.writer == null) {
                FileOutputStream fos = new FileOutputStream(this.logFile, true);
                CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, encoder));
            }
            if (this.renderHead) {
                this.headRenderer.render(this.writer);
                this.renderHead = false;
            }
            this.bodyRenderer.render(this.writer);
            this.writer.flush();
            this.lastModified = this.logFile.lastModified();
            if (this.logFile.length() > (long)this.maxRollingFileSizeBytes) {
                this.rollover();
            }
        }
        catch (IOException e) {
            this.log(e);
            this.logFile = null;
            IOUtil.closeResource(this.writer);
            this.writer = null;
        }
        catch (RuntimeException e) {
            this.logger.severe("Failed to write PerformanceLogFile: " + this.logFile, e);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void rollover() {
        IOUtil.closeResource(this.writer);
        this.writer = null;
        this.logFile = null;
        ++this.index;
        File file = new File(String.format(this.pathname, this.index - this.maxRollingFileCount));
        file.delete();
    }

    private void log(IOException e) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("PerformanceMonitor failed to output to file:" + this.logFile.getAbsolutePath() + " cause:" + e.getMessage(), e);
        } else {
            this.logger.warning("PerformanceMonitor failed to output to file:" + this.logFile.getAbsolutePath() + " cause:" + e.getMessage());
        }
    }

    boolean isRenderingForced() {
        if (this.logFile == null) {
            return false;
        }
        return this.logFile.lastModified() != this.lastModified;
    }

    private final class HeadRenderer {
        private HeadRenderer() {
        }

        private void render(BufferedWriter writer) throws IOException {
            this.renderBuildInfo(writer);
            writer.append("\n\n");
            this.renderSystemProperties(writer);
            writer.append("\n\n");
            this.renderConfigProperties(writer);
            writer.append("\n\n");
            writer.flush();
        }

        private void renderSystemProperties(BufferedWriter writer) throws IOException {
            writer.append("================[ System Properties ]===================================\n");
            writer.append(String.format("%-30s  %4s%n", "property", "value"));
            writer.append("------------------------------------------------------------------------\n");
            LinkedList<Object> keys = new LinkedList<Object>();
            keys.addAll(System.getProperties().keySet());
            Collections.sort(keys);
            for (Object e : keys) {
                String keyString = (String)e;
                if (this.ignore(keyString)) continue;
                String value = System.getProperty(keyString);
                String s = this.formatKeyValue(keyString, value);
                writer.append(s);
            }
            writer.append(this.formatKeyValue("jvm.args", this.getInputArgs()));
        }

        private String getInputArgs() {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            List<String> arguments = runtimeMxBean.getInputArguments();
            StringBuffer sb = new StringBuffer();
            sb.append("jvm.args=");
            for (String argument : arguments) {
                sb.append(argument);
                sb.append(" ");
            }
            return sb.toString();
        }

        private void renderConfigProperties(BufferedWriter writer) throws IOException {
            writer.append("=================[ Hazelcast Config ]===================================\n");
            writer.append(String.format("%-60s  %4s%n", "property", "value"));
            writer.append("------------------------------------------------------------------------\n");
            LinkedList<Object> keys = new LinkedList<Object>();
            Properties properties = PerformanceLogFile.this.hazelcastInstance.getConfig().getProperties();
            keys.addAll(properties.keySet());
            Collections.sort(keys);
            for (Object e : keys) {
                String keyString = (String)e;
                String value = properties.getProperty(keyString);
                writer.append(String.format("%-60s  %4s%n", keyString, value));
            }
        }

        private void renderBuildInfo(BufferedWriter writer) throws IOException {
            writer.append("====================[ Build Info ]======================================\n");
            writer.append(String.format("%-30s  %4s%n", "property", "value"));
            writer.append("------------------------------------------------------------------------\n");
            BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();
            writer.append(this.formatKeyValue("Version", buildInfo.getVersion()));
            writer.append(this.formatKeyValue("Build", buildInfo.getBuild()));
            writer.append(this.formatKeyValue("BuildNumber", buildInfo.getBuildNumber()));
            writer.append(this.formatKeyValue("Revision", buildInfo.getVersion()));
            writer.append(this.formatKeyValue("Enterprise", buildInfo.isEnterprise()));
        }

        private String formatKeyValue(String keyString, Object value) {
            return String.format("%-30s  %4s%n", keyString, value);
        }

        private boolean ignore(String systemProperty) {
            if (systemProperty.startsWith("java.awt")) {
                return true;
            }
            return !systemProperty.startsWith("java") && !systemProperty.startsWith("hazelcast") && !systemProperty.startsWith("sun") && !systemProperty.startsWith("os");
        }
    }

    private final class BodyRenderer {
        private final SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        private final ProbeRenderer probeRenderer;

        public BodyRenderer(boolean humanFriendlyFormat) {
            this.probeRenderer = humanFriendlyFormat ? new HumanFriendlyProbeRenderer() : new CommaSeparatedKeyValueProbeRenderer();
        }

        private void render(BufferedWriter writer) throws IOException {
            this.renderHeader(writer);
            this.renderMetricsRegistry(writer);
            writer.append("\n\n");
            if (this.renderSlowOperation(writer)) {
                writer.append("\n\n");
            }
        }

        private void renderHeader(BufferedWriter writer) throws IOException {
            writer.append("================[ Metrics ]============================================\n");
            Calendar calendar = Calendar.getInstance();
            writer.append(this.sdf.format(calendar.getTime())).append('\n');
            writer.append("------------------------------------------------------------------------\n");
        }

        private void renderMetricsRegistry(BufferedWriter writer) throws IOException {
            PerformanceLogFile.this.metricRegistry.render(this.probeRenderer);
            writer.append(this.probeRenderer.getResult());
        }

        private boolean renderSlowOperation(BufferedWriter writer) throws IOException {
            List<SlowOperationDTO> slowOperations = PerformanceLogFile.this.operationService.getSlowOperationDTOs();
            if (slowOperations.isEmpty()) {
                return false;
            }
            writer.append("================[ Slow Operations ]=====================================\n");
            int k = 1;
            for (SlowOperationDTO slowOperation : slowOperations) {
                writer.append("#" + k).append("\n    " + slowOperation.operation).append("\n    Invocations: " + slowOperation.totalInvocations).append("\n    Stacktrace:\n");
                writer.append(slowOperation.stackTrace).append("\n\n");
                ++k;
            }
            return true;
        }
    }
}

