/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.key;

import com.googlecode.ehcache.annotations.key.AbstractDeepCacheKeyGenerator;
import com.googlecode.ehcache.annotations.key.ReadOnlyList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCacheKeyGenerator
extends AbstractDeepCacheKeyGenerator<ListKeyGenerator, ReadOnlyList<?>> {
    public static final String DEFAULT_BEAN_NAME = "com.googlecode.ehcache.annotations.key.ListCacheKeyGenerator.DEFAULT_BEAN_NAME";

    public ListCacheKeyGenerator() {
    }

    public ListCacheKeyGenerator(boolean includeMethod, boolean includeParameterTypes) {
        super(includeMethod, includeParameterTypes);
    }

    @Override
    public ListKeyGenerator getGenerator(Object ... data) {
        return new ListKeyGenerator();
    }

    @Override
    public ReadOnlyList<?> generateKey(ListKeyGenerator generator) {
        ArrayList key = (ArrayList)generator.keyStack.getFirst();
        return new ReadOnlyList(key);
    }

    @Override
    protected void beginRecursion(ListKeyGenerator generator, Object e) {
        ArrayList previous = generator.current;
        if (e.getClass().isArray()) {
            int size = Array.getLength(e);
            generator.current = new ArrayList(size);
        } else if (e instanceof Collection) {
            int size = ((Collection)e).size();
            generator.current = new ArrayList(size);
        } else if (e instanceof Map.Entry) {
            generator.current = new ArrayList(2);
        } else {
            generator.current = new ArrayList();
        }
        generator.keyStack.addFirst(generator.current);
        if (previous != null) {
            previous.add(generator.current);
        }
    }

    @Override
    protected void endRecursion(ListKeyGenerator generator, Object e) {
        if (generator.keyStack.size() > 1) {
            generator.keyStack.removeFirst();
            generator.current = (ArrayList)generator.keyStack.peek();
        }
    }

    @Override
    protected void appendGraphCycle(ListKeyGenerator generator, Object o) {
        this.append(generator, (Object)null);
    }

    @Override
    protected void appendNull(ListKeyGenerator generator) {
        this.append(generator, (Object)null);
    }

    @Override
    protected void append(ListKeyGenerator generator, Object e) {
        if (generator.current == null) {
            this.beginRecursion(generator, e);
        }
        generator.current.add(e);
    }

    public static class ListKeyGenerator {
        private final LinkedList<ArrayList<Object>> keyStack = new LinkedList();
        private ArrayList<Object> current;

        private ListKeyGenerator() {
        }
    }
}

