/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.support.builder;

import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.builder.AbstractDataBuilder;
import com.google.code.ssm.api.CacheOperation;
import com.google.code.ssm.api.ParameterDataUpdateContent;
import com.google.code.ssm.api.ReturnDataUpdateContent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;

public class DataIndexBuilder
extends AbstractDataBuilder {
    @Override
    protected void build(AnnotationData data, Annotation annotation, Class<? extends Annotation> expectedAnnotationClass, Method targetMethod) {
        if (this.isReturnDataUpdateContent(targetMethod)) {
            data.setReturnDataIndex(true);
            return;
        }
        Integer foundIndex = this.getIndexOfAnnotatedParam(targetMethod, ParameterDataUpdateContent.class);
        if (foundIndex == null) {
            throw new InvalidParameterException(String.format("No ReturnDataUpdateContent or ParameterDataUpdateContent annotation found on method [%s]", targetMethod.getName()));
        }
        data.setDataIndex(foundIndex);
    }

    @Override
    protected boolean support(Class<? extends Annotation> expectedAnnotationClass) {
        return this.isType(expectedAnnotationClass, CacheOperation.Type.UPDATE);
    }

    private boolean isReturnDataUpdateContent(Method method) {
        ReturnDataUpdateContent returnAnnotation = method.getAnnotation(ReturnDataUpdateContent.class);
        if (returnAnnotation != null) {
            if (method.getReturnType().equals(Void.TYPE)) {
                this.throwException("Annotation [%s] is defined on void method [%s]", ReturnDataUpdateContent.class, method);
            }
            return true;
        }
        return false;
    }

    private Integer getIndexOfAnnotatedParam(Method method, Class<? extends Annotation> annotationClass) {
        Annotation[][] paramAnnotationArrays = method.getParameterAnnotations();
        Integer foundIndex = null;
        if (paramAnnotationArrays != null && paramAnnotationArrays.length > 0) {
            for (int ix = 0; ix < paramAnnotationArrays.length; ++ix) {
                if (this.getAnnotation(annotationClass, paramAnnotationArrays[ix]) == null) continue;
                if (foundIndex != null) {
                    this.throwException("Multiple annotations of type [%s] found on method [%s]", annotationClass, method);
                }
                foundIndex = ix;
            }
        }
        return foundIndex;
    }
}

