/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop.support;

import com.google.code.ssm.aop.support.BridgeMethodMappingStore;
import com.google.code.ssm.aop.support.InvalidAnnotationException;
import com.google.code.ssm.api.BridgeMethodMapping;
import com.google.code.ssm.api.BridgeMethodMappings;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BridgeMethodMappingStoreImpl
implements BridgeMethodMappingStore {
    private final Map<Class<?>, Map<String, Map<String, Class<?>[]>>> map = new ConcurrentHashMap();

    @Override
    public Class<?>[] getTargetParamsTypes(Class<?> clazz, String methodName, Class<?>[] erasedParamTypes) {
        if (!this.map.containsKey(clazz)) {
            this.processBridgeMethodMappingsAnnotation(clazz);
        }
        Map<String, Map<String, Class<?>[]>> methodNameMap = this.map.get(clazz);
        Map<String, Class<?>[]> erasedParamTypesMap = null;
        Class<?>[] targetParamTypes = null;
        if (methodNameMap != null) {
            erasedParamTypesMap = methodNameMap.get(methodName);
        }
        String key = Arrays.toString(erasedParamTypes);
        if (erasedParamTypesMap != null) {
            targetParamTypes = erasedParamTypesMap.get(key);
        }
        if (targetParamTypes == null) {
            throw new RuntimeException(String.format("Annotation [%s] must be defined on [%s] for bridge method [%s] with erased param types [%s]", BridgeMethodMappings.class.getName(), clazz.getName(), methodName, key));
        }
        return targetParamTypes;
    }

    private void processBridgeMethodMappingsAnnotation(Class<?> clazz) {
        BridgeMethodMappings bridgeMethodMappings = clazz.getAnnotation(BridgeMethodMappings.class);
        ConcurrentHashMap<String, Map<String, Class<?>[]>> methodNameMap = new ConcurrentHashMap<String, Map<String, Class<?>[]>>();
        if (bridgeMethodMappings != null) {
            for (BridgeMethodMapping methodMapping : bridgeMethodMappings.value()) {
                this.addMethodMapping(clazz, methodNameMap, methodMapping.methodName(), methodMapping.erasedParamTypes(), methodMapping.targetParamTypes());
            }
        }
        this.map.put(clazz, methodNameMap);
    }

    private void addMethodMapping(Class<?> clazz, Map<String, Map<String, Class<?>[]>> methodNameMap, String methodName, Class<?>[] erasedParamTypes, Class<?>[] targetParamTypes) {
        Map<String, Class<?>[]> erasedParamTypesMap = methodNameMap.get(methodName);
        String erasedParamTypesKey = Arrays.toString(erasedParamTypes);
        if (erasedParamTypesMap == null) {
            if (erasedParamTypes.length != targetParamTypes.length) {
                throw new InvalidAnnotationException(String.format("Annotation [%s] defined on class [%s] for method [%s] must have the same number of types in erasedParamTypes and targetParamTypes", BridgeMethodMapping.class.getName(), clazz.getName(), methodName));
            }
            erasedParamTypesMap = new ConcurrentHashMap<String, Class<?>[]>();
            methodNameMap.put(methodName, erasedParamTypesMap);
        } else if (erasedParamTypesMap.containsKey(erasedParamTypesKey)) {
            throw new InvalidAnnotationException(String.format("@BridgeMethodMappings annotation on class [%s] defines two or more mappings for the same bridge method, method name [%s], erased param types: [%s]", clazz, methodName, erasedParamTypesKey));
        }
        erasedParamTypesMap.put(erasedParamTypesKey, targetParamTypes);
    }
}

