/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.aop;

import com.google.code.ssm.Cache;
import com.google.code.ssm.PrefixedCacheImpl;
import com.google.code.ssm.Settings;
import com.google.code.ssm.aop.UndefinedCacheException;
import com.google.code.ssm.aop.support.AnnotationData;
import com.google.code.ssm.aop.support.BridgeMethodMappingStore;
import com.google.code.ssm.aop.support.BridgeMethodMappingStoreImpl;
import com.google.code.ssm.aop.support.CacheKeyBuilder;
import com.google.code.ssm.aop.support.CacheKeyBuilderImpl;
import com.google.code.ssm.aop.support.InvalidAnnotationException;
import com.google.code.ssm.aop.support.PertinentNegativeNull;
import com.google.code.ssm.api.format.Serialization;
import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.util.Utils;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CacheBase
implements ApplicationContextAware,
InitializingBean {
    public static final String DISABLE_CACHE_PROPERTY = "ssm.cache.disable";
    private static final Logger LOG = LoggerFactory.getLogger(CacheBase.class);
    private CacheKeyBuilder cacheKeyBuilder = new CacheKeyBuilderImpl();
    private BridgeMethodMappingStore bridgeMethodMappingStore = new BridgeMethodMappingStoreImpl();
    private final Map<String, Cache> caches = new HashMap<String, Cache>();
    private Settings settings = new Settings();
    private ApplicationContext context;

    public void afterPropertiesSet() throws Exception {
        try {
            this.settings = (Settings)this.context.getBean(Settings.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            LOG.info("Cannot obtain custom SSM settings, default is used");
        }
        for (Cache cache : this.context.getBeansOfType(Cache.class).values()) {
            this.addCache(cache);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    public void setCacheKeyBuilder(CacheKeyBuilder cacheKeyBuilder) {
        this.cacheKeyBuilder = cacheKeyBuilder;
    }

    public CacheKeyBuilder getCacheKeyBuilder() {
        return this.cacheKeyBuilder;
    }

    public BridgeMethodMappingStore getBridgeMethodMappingStore() {
        return this.bridgeMethodMappingStore;
    }

    public void setBridgeMethodMappingStore(BridgeMethodMappingStore bridgeMethodMappingStore) {
        this.bridgeMethodMappingStore = bridgeMethodMappingStore;
    }

    public Cache getCache(AnnotationData data) {
        Cache cache = this.caches.get(data.getCacheName());
        if (cache == null) {
            throw new UndefinedCacheException(data.getCacheName());
        }
        if (cache.getProperties().isUseNameAsKeyPrefix()) {
            return new PrefixedCacheImpl(cache, data.getCacheName(), cache.getProperties().getKeyPrefixSeparator());
        }
        return cache;
    }

    public boolean isCacheDisabled() {
        String disableProperty = System.getProperty(DISABLE_CACHE_PROPERTY);
        return Boolean.toString(true).equals(disableProperty) || !Boolean.toString(false).equals(disableProperty) && this.settings.isDisableCache();
    }

    public Method getMethodToCache(JoinPoint jp) throws NoSuchMethodException {
        Class[] parameters;
        String name;
        Signature sig = jp.getSignature();
        if (!(sig instanceof MethodSignature)) {
            throw new InvalidAnnotationException("This annotation is only valid on a method.");
        }
        MethodSignature msig = (MethodSignature)sig;
        Object target = jp.getTarget();
        Method method = this.findMethodFromTargetGivenNameAndParams(target, name = msig.getName(), parameters = msig.getParameterTypes());
        if (method.isBridge()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Method is bridge. Name {}, params: {}", (Object)name, (Object)parameters);
            }
            parameters = this.bridgeMethodMappingStore.getTargetParamsTypes(target.getClass(), name, parameters);
            method = this.findMethodFromTargetGivenNameAndParams(target, name, parameters);
        }
        return method;
    }

    public <T> T getUpdateData(AnnotationData data, Method method, Object[] args, Object returnValue) throws Exception {
        return (T)(data.isReturnDataIndex() ? returnValue : Utils.getMethodArg(data.getDataIndex(), args, method.toString()));
    }

    protected Settings getSettings() {
        return this.settings;
    }

    protected Object getSubmission(Object o) {
        return o == null ? PertinentNegativeNull.NULL : o;
    }

    protected Object getResult(Object result) {
        return result instanceof PertinentNegativeNull ? null : result;
    }

    protected void verifyReturnTypeIsList(Method method, Class<?> annotationClass) {
        if (!this.verifyTypeIsList(method.getReturnType())) {
            throw new InvalidAnnotationException(String.format("The annotation [%s] is only valid on a method that returns a [%s] or its subclass. [%s] does not fulfill this requirement.", annotationClass.getName(), List.class.getName(), method.toString()));
        }
    }

    protected boolean verifyTypeIsList(Class<?> clazz) {
        return List.class.isAssignableFrom(clazz);
    }

    protected void verifyReturnTypeIsNoVoid(Method method, Class<?> annotationClass) {
        if (method.getReturnType().equals(Void.TYPE)) {
            throw new InvalidParameterException(String.format("Annotation [%s] is defined on void method  [%s]", annotationClass, method.getName()));
        }
    }

    protected SerializationType getSerializationType(Method method) {
        Serialization serialization = method.getAnnotation(Serialization.class);
        if (serialization != null) {
            return serialization.value();
        }
        serialization = method.getDeclaringClass().getAnnotation(Serialization.class);
        if (serialization != null) {
            return serialization.value();
        }
        return null;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected void addCache(Cache cache) {
        if (cache == null) {
            this.getLogger().warn("One of the cache is null");
            return;
        }
        if (this.caches.put(cache.getName(), cache) != null) {
            String errorMsg = "There are two or more caches with the same name '" + cache.getName() + "'";
            this.getLogger().error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        for (String alias : cache.getAliases()) {
            if (this.caches.containsKey(alias)) {
                String errorMsg = String.format("The cache with name '%s' uses alias '%s' already defined by cache with name '%s'", cache.getName(), alias, this.caches.get(alias).getName());
                this.getLogger().error(errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            this.caches.put(alias, cache);
        }
    }

    private Method findMethodFromTargetGivenNameAndParams(Object target, String name, Class<?>[] parameters) throws NoSuchMethodException {
        Method method = target.getClass().getMethod(name, parameters);
        this.getLogger().debug("Method to cache: {}", (Object)method);
        return method;
    }
}

