/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.repository;

import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnJavaScmProviderRepository
extends SvnScmProviderRepository {
    private SVNURL svnUrl;
    private SVNClientManager clientManager;

    public SvnJavaScmProviderRepository(SVNURL svnUrl, String strUrl) {
        super(strUrl, null, null);
        this.setUser(svnUrl.getUserInfo());
        this.setPassword(null);
        this.svnUrl = svnUrl;
        if (this.getUser() != null) {
            System.getProperties().setProperty("javasvn.ssh2.username", this.getUser());
        }
        if (this.getPassword() != null) {
            System.getProperties().setProperty("javasvn.ssh2.password", this.getPassword());
        }
        this.initializeClientManager();
    }

    public SVNURL getSvnUrl() {
        return this.svnUrl;
    }

    public SVNClientManager getClientManager() {
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        return SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)SVNWCUtil.createDefaultAuthenticationManager((String)this.getUser(), (String)this.getPassword()));
    }

    public void setPrivateKey(String privateKey) {
        super.setPrivateKey(privateKey);
        if (this.getPrivateKey() != null) {
            System.getProperties().setProperty("javasvn.ssh2.key", this.getPrivateKey());
        }
        this.initializeClientManager();
    }

    public void setPassphrase(String passphrase) {
        super.setPassphrase(passphrase);
        if (this.getPassphrase() != null) {
            System.getProperties().setProperty("javasvn.ssh2.passphrase", this.getPassphrase());
        }
        this.initializeClientManager();
    }

    public void setUser(String user) {
        super.setUser(user);
        if (this.getUser() != null) {
            System.getProperties().setProperty("javasvn.ssh2.username", this.getUser());
        }
        this.initializeClientManager();
    }

    public void setPassword(String password) {
        super.setPassword(password);
        if (this.getPassword() != null) {
            System.getProperties().setProperty("javasvn.ssh2.password", this.getPassword());
        }
        this.initializeClientManager();
    }

    private void initializeClientManager() {
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        this.clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)SVNWCUtil.createDefaultAuthenticationManager());
    }
}

