/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.info;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.command.info.SvnInfoItem;
import org.apache.maven.scm.provider.svn.command.info.SvnInfoScmResult;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnJavaInfoCommand
extends AbstractCommand
implements SvnCommand {
    protected ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return this.executeInfoCommand(repository, fileSet, parameters, false, "");
    }

    public SvnInfoScmResult executeInfoCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters, boolean recursive, String revision) throws ScmException {
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repository;
        ArrayList<SvnInfoItem> infoItems = new ArrayList<SvnInfoItem>();
        SvnInfoScmResult svnInfoScmResult = new SvnInfoScmResult(null, infoItems);
        Iterator i = fileSet.getFileList().iterator();
        if (i.hasNext()) {
            while (i.hasNext()) {
                SvnInfoItem currentItem = this.executeSingleInfoCommand(javaRepo, (File)i.next(), revision);
                infoItems.add(currentItem);
            }
        } else {
            SvnInfoItem currentItem = this.executeSingleInfoCommand(javaRepo, fileSet.getBasedir(), revision);
            infoItems.add(currentItem);
        }
        return svnInfoScmResult;
    }

    private SvnInfoItem executeSingleInfoCommand(SvnJavaScmProviderRepository javaRepo, File f, String revision) throws ScmException {
        try {
            SVNRevision svnRev = null;
            if (revision != null) {
                svnRev = SVNRevision.parse((String)revision);
            }
            SVNInfo svnInfo = javaRepo.getClientManager().getWCClient().doInfo(f, svnRev);
            SvnInfoItem currentItem = new SvnInfoItem();
            currentItem.setRevision(Long.toString(svnInfo.getRevision().getNumber()));
            currentItem.setLastChangedAuthor(svnInfo.getAuthor());
            currentItem.setLastChangedRevision(Long.toString(svnInfo.getCommittedRevision().getNumber()));
            currentItem.setLastChangedDate(svnInfo.getCommittedDate().toString());
            currentItem.setURL(svnInfo.getURL().toString());
            currentItem.setRepositoryUUID(svnInfo.getRepositoryUUID());
            currentItem.setRepositoryRoot(svnInfo.getRepositoryRootURL().toString());
            currentItem.setNodeKind(svnInfo.getKind().toString());
            return currentItem;
        }
        catch (SVNException e) {
            throw new ScmException(e.getMessage(), (Throwable)e);
        }
    }
}

