/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import com.google.monitoring.runtime.instrumentation.asm.ClassVisitor;
import com.google.monitoring.runtime.instrumentation.asm.ClassWriter;
import com.google.monitoring.runtime.instrumentation.asm.MethodVisitor;
import com.google.monitoring.runtime.instrumentation.asm.commons.CodeSizeEvaluator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VerifyingClassAdapter
extends ClassVisitor {
    private static final Logger logger = Logger.getLogger(VerifyingClassAdapter.class.getName());
    final ClassWriter cw;
    final byte[] original;
    final String className;
    String message = "The class has not finished being examined";
    State state = State.UNKNOWN;

    public VerifyingClassAdapter(ClassWriter cw, byte[] original, String className) {
        super(327680, cw);
        this.cw = cw;
        this.original = original;
        this.className = className.replace('/', '.');
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return new CodeSizeEvaluator(mv){

            @Override
            public void visitEnd() {
                super.visitEnd();
                if (this.getMaxSize() > 65536) {
                    VerifyingClassAdapter.this.state = State.FAIL_TOO_LONG;
                    String string = String.valueOf(String.valueOf(name));
                    VerifyingClassAdapter.this.message = new StringBuilder(25 + string.length()).append("the method ").append(string).append(" was too long.").toString();
                }
            }
        };
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.state == State.UNKNOWN) {
            this.state = State.PASS;
        }
    }

    public boolean isVerified() {
        return this.state == State.PASS;
    }

    public byte[] toByteArray() {
        if (this.state != State.PASS) {
            String string = String.valueOf(String.valueOf(this.className));
            String string2 = String.valueOf(String.valueOf(this.message));
            logger.log(Level.WARNING, new StringBuilder(36 + string.length() + string2.length()).append("Failed to instrument class ").append(string).append(" because ").append(string2).toString());
            return this.original;
        }
        return this.cw.toByteArray();
    }

    public static enum State {
        PASS,
        UNKNOWN,
        FAIL_TOO_LONG;

    }
}

