/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import com.google.monitoring.runtime.instrumentation.asm.ClassReader;
import com.google.monitoring.runtime.instrumentation.asm.ClassWriter;
import com.google.monitoring.runtime.instrumentation.asm.Type;
import java.io.IOException;
import java.io.InputStream;

class StaticClassWriter
extends ClassWriter {
    private final ClassLoader classLoader;

    public StaticClassWriter(ClassReader classReader, int flags, ClassLoader classLoader) {
        super(classReader, flags);
        this.classLoader = classLoader;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        try {
            return super.getCommonSuperClass(type1, type2);
        }
        catch (Throwable e) {
            ClassInfo ci2;
            ClassInfo ci1;
            try {
                ci1 = new ClassInfo(type1, this.classLoader);
                ci2 = new ClassInfo(type2, this.classLoader);
            }
            catch (Throwable e2) {
                throw new RuntimeException(e2);
            }
            if (ci1.isAssignableFrom(ci2)) {
                return type1;
            }
            if (ci2.isAssignableFrom(ci1)) {
                return type2;
            }
            if (ci1.isInterface() || ci2.isInterface()) {
                return "java/lang/Object";
            }
            while (!(ci1 = ci1.getSuperclass()).isAssignableFrom(ci2)) {
            }
            return ci1.getType().getInternalName();
        }
    }

    static class ClassInfo {
        private final Type type;
        private final ClassLoader loader;
        private final boolean isInterface;
        private final String superClass;
        private final String[] interfaces;

        public ClassInfo(String type, ClassLoader loader) {
            ClassReader cr;
            Class<?> cls = null;
            try {
                cls = Class.forName(type);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (cls != null) {
                this.type = Type.getType(cls);
                this.loader = loader;
                this.isInterface = cls.isInterface();
                this.superClass = cls.getSuperclass().getName();
                Class<?>[] ifs = cls.getInterfaces();
                this.interfaces = new String[ifs.length];
                for (int i = 0; i < ifs.length; ++i) {
                    this.interfaces[i] = ifs[i].getName();
                }
                return;
            }
            this.loader = loader;
            this.type = Type.getObjectType(type);
            String fileName = String.valueOf(type.replace('.', '/')).concat(".class");
            InputStream is = null;
            try {
                is = loader == null ? ClassLoader.getSystemResourceAsStream(fileName) : loader.getResourceAsStream(fileName);
                cr = new ClassReader(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
            }
            int offset = cr.header;
            this.isInterface = (cr.readUnsignedShort(offset) & 0x200) != 0;
            char[] buf = new char[2048];
            this.superClass = this.readConstantPoolString(cr, offset += 4, buf);
            int numInterfaces = cr.readUnsignedShort(offset += 2);
            this.interfaces = new String[numInterfaces];
            offset += 2;
            for (int i = 0; i < numInterfaces; ++i) {
                this.interfaces[i] = this.readConstantPoolString(cr, offset, buf);
                offset += 2;
            }
        }

        String readConstantPoolString(ClassReader cr, int offset, char[] buf) {
            int cpIndex = cr.getItem(cr.readUnsignedShort(offset));
            if (cpIndex == 0) {
                return null;
            }
            return cr.readUTF8(cpIndex, buf);
        }

        Type getType() {
            return this.type;
        }

        ClassInfo getSuperclass() {
            if (this.superClass == null) {
                return null;
            }
            return new ClassInfo(this.superClass, this.loader);
        }

        ClassInfo[] getInterfaces() {
            if (this.interfaces == null) {
                return new ClassInfo[0];
            }
            ClassInfo[] result = new ClassInfo[this.interfaces.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new ClassInfo(this.interfaces[i], this.loader);
            }
            return result;
        }

        boolean isInterface() {
            return this.isInterface;
        }

        private boolean implementsInterface(ClassInfo that) {
            for (ClassInfo c = this; c != null; c = c.getSuperclass()) {
                for (ClassInfo iface : c.getInterfaces()) {
                    if (!iface.type.equals(that.type) && !iface.implementsInterface(that)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isSubclassOf(ClassInfo that) {
            for (ClassInfo ci = this; ci != null; ci = ci.getSuperclass()) {
                if (ci.getSuperclass() == null || !ci.getSuperclass().type.equals(that.type)) continue;
                return true;
            }
            return false;
        }

        boolean isAssignableFrom(ClassInfo that) {
            return this == that || that.isSubclassOf(this) || that.implementsInterface(this) || that.isInterface() && this.getType().getDescriptor().equals("Ljava/lang/Object;");
        }
    }
}

